/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectEnumerableAssert;
import org.assertj.core.api.iterable.Extractor;
import org.assertj.core.extractor.Extractors;
import org.assertj.core.groups.FieldsOrPropertiesExtractor;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.IgnoringFieldsComparator;
import org.assertj.core.internal.IterableElementComparisonStrategy;
import org.assertj.core.internal.Iterables;
import org.assertj.core.internal.ObjectArrays;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.OnFieldsComparator;
import org.assertj.core.util.Lists;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractIterableAssert<S extends AbstractIterableAssert<S, A, T>, A extends Iterable<? extends T>, T>
extends AbstractAssert<S, A>
implements ObjectEnumerableAssert<S, T> {
    @VisibleForTesting
    Iterables iterables = Iterables.instance();

    protected AbstractIterableAssert(A actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.iterables.assertNullOrEmpty(this.info, (Iterable)this.actual);
    }

    @Override
    public void isEmpty() {
        this.iterables.assertEmpty(this.info, (Iterable)this.actual);
    }

    @Override
    public S isNotEmpty() {
        this.iterables.assertNotEmpty(this.info, (Iterable)this.actual);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S hasSize(int expected) {
        this.iterables.assertHasSize(this.info, (Iterable)this.actual, expected);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Object other) {
        this.iterables.assertHasSameSizeAs((AssertionInfo)this.info, (Iterable)this.actual, other);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Iterable<?> other) {
        this.iterables.assertHasSameSizeAs((AssertionInfo)this.info, (Iterable)this.actual, other);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S contains(T ... values) {
        this.iterables.assertContains(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsOnly(T ... values) {
        this.iterables.assertContainsOnly(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsOnlyOnce(T ... values) {
        this.iterables.assertContainsOnlyOnce(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsExactly(T ... values) {
        this.iterables.assertContainsExactly(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S isSubsetOf(Iterable<? extends T> values) {
        this.iterables.assertIsSubsetOf(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsSequence(T ... sequence) {
        this.iterables.assertContainsSequence(this.info, (Iterable)this.actual, sequence);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsSubsequence(T ... sequence) {
        this.iterables.assertContainsSubsequence(this.info, (Iterable)this.actual, sequence);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doesNotContain(T ... values) {
        this.iterables.assertDoesNotContain(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doesNotContainAnyElementsOf(Iterable<? extends T> iterable) {
        this.iterables.assertDoesNotContainAnyElementsOf(this.info, (Iterable)this.actual, iterable);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doesNotHaveDuplicates() {
        this.iterables.assertDoesNotHaveDuplicates(this.info, (Iterable)this.actual);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S startsWith(T ... sequence) {
        this.iterables.assertStartsWith(this.info, (Iterable)this.actual, sequence);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S endsWith(T ... sequence) {
        this.iterables.assertEndsWith(this.info, (Iterable)this.actual, sequence);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsNull() {
        this.iterables.assertContainsNull(this.info, (Iterable)this.actual);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doesNotContainNull() {
        this.iterables.assertDoesNotContainNull(this.info, (Iterable)this.actual);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S are(Condition<? super T> condition) {
        this.iterables.assertAre(this.info, (Iterable)this.actual, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areNot(Condition<? super T> condition) {
        this.iterables.assertAreNot(this.info, (Iterable)this.actual, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S have(Condition<? super T> condition) {
        this.iterables.assertHave(this.info, (Iterable)this.actual, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doNotHave(Condition<? super T> condition) {
        this.iterables.assertDoNotHave(this.info, (Iterable)this.actual, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areAtLeastOne(Condition<? super T> condition) {
        this.areAtLeast(1, (Condition)condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areAtLeast(int times, Condition<? super T> condition) {
        this.iterables.assertAreAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areAtMost(int times, Condition<? super T> condition) {
        this.iterables.assertAreAtMost(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areExactly(int times, Condition<? super T> condition) {
        this.iterables.assertAreExactly(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S haveAtLeastOne(Condition<? super T> condition) {
        return (S)this.haveAtLeast(1, (Condition)condition);
    }

    @Override
    public S haveAtLeast(int times, Condition<? super T> condition) {
        this.iterables.assertHaveAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S haveAtMost(int times, Condition<? super T> condition) {
        this.iterables.assertHaveAtMost(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S haveExactly(int times, Condition<? super T> condition) {
        this.iterables.assertHaveExactly(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S hasAtLeastOneElementOfType(Class<?> expectedType) {
        ObjectArrays.instance().assertHasAtLeastOneElementOfType(this.info, org.assertj.core.util.Iterables.toArray((Iterable)this.actual), expectedType);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S hasOnlyElementsOfType(Class<?> expectedType) {
        ObjectArrays.instance().assertHasOnlyElementsOfType(this.info, org.assertj.core.util.Iterables.toArray((Iterable)this.actual), expectedType);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsAll(Iterable<? extends T> iterable) {
        this.iterables.assertContainsAll(this.info, (Iterable)this.actual, iterable);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S usingElementComparator(Comparator<? super T> elementComparator) {
        this.iterables = new Iterables(new ComparatorBasedComparisonStrategy(elementComparator));
        this.objects = new Objects(new IterableElementComparisonStrategy<T>(elementComparator));
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S usingDefaultElementComparator() {
        this.usingDefaultComparator();
        this.iterables = Iterables.instance();
        return (S)((AbstractIterableAssert)this.myself);
    }

    public ListAssert<Object> extracting(String propertyOrField) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(propertyOrField));
        return new ListAssert<Object>(values);
    }

    public ListAssert<Object> extractingResultOf(String method) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.resultOf(method));
        return new ListAssert<Object>(values);
    }

    public <P> ListAssert<P> extractingResultOf(String method, Class<P> extractedType) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.resultOf(method));
        return new ListAssert<Object>(values);
    }

    public <P> ListAssert<P> extracting(String propertyOrField, Class<P> extractingType) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(propertyOrField));
        return new ListAssert<Object>(values);
    }

    public ListAssert<Tuple> extracting(String ... propertiesOrFields) {
        List<Tuple> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(propertiesOrFields));
        return new ListAssert<Tuple>(values);
    }

    public <V> ListAssert<V> extracting(Extractor<? super T, V> extractor) {
        List<V> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, extractor);
        return new ListAssert<V>(values);
    }

    public <V> ListAssert<V> flatExtracting(Extractor<? super T, ? extends Collection<V>> extractor) {
        ArrayList result = Lists.newArrayList();
        List<Collection<V>> extractedValues = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, extractor);
        for (Collection<V> iterable : extractedValues) {
            result.addAll(iterable);
        }
        return new ListAssert(result);
    }

    @SafeVarargs
    public final ListAssert<Tuple> extracting(Function<T, ?> ... extractors) {
        Function<Object, Tuple> tupleExtractor = objectToExtractValueFrom -> {
            Tuple tuple = new Tuple(new Object[0]);
            for (Function extractor : extractors) {
                tuple.addData(extractor.apply(objectToExtractValueFrom));
            }
            return tuple;
        };
        List tuples = StreamSupport.stream(((Iterable)this.actual).spliterator(), false).map(tupleExtractor).collect(Collectors.toList());
        return new ListAssert<Tuple>(tuples);
    }

    @Override
    public S containsExactlyElementsOf(Iterable<? extends T> iterable) {
        return (S)this.containsExactly((Object[])org.assertj.core.util.Iterables.toArray(iterable));
    }

    @Override
    public S containsOnlyElementsOf(Iterable<? extends T> iterable) {
        return (S)this.containsOnly((Object[])org.assertj.core.util.Iterables.toArray(iterable));
    }

    @Override
    public S hasSameElementsAs(Iterable<? extends T> iterable) {
        return (S)this.containsOnlyElementsOf((Iterable)iterable);
    }

    public S usingFieldByFieldElementComparator() {
        return (S)this.usingElementComparator((Comparator)new FieldByFieldComparator());
    }

    public S usingElementComparatorOnFields(String ... fields) {
        return (S)this.usingElementComparator((Comparator)new OnFieldsComparator(fields));
    }

    protected S usingComparisonStrategy(ComparisonStrategy comparisonStrategy) {
        this.iterables = new Iterables(comparisonStrategy);
        return (S)((AbstractIterableAssert)this.myself);
    }

    public S usingElementComparatorIgnoringFields(String ... fields) {
        return (S)this.usingElementComparator((Comparator)new IgnoringFieldsComparator(fields));
    }

    @Override
    public S inHexadecimal() {
        return (S)((AbstractIterableAssert)super.inHexadecimal());
    }

    @Override
    public S inBinary() {
        return (S)((AbstractIterableAssert)super.inBinary());
    }
}

