/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.NumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Integers;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractIntegerAssert<S extends AbstractIntegerAssert<S>>
extends AbstractComparableAssert<S, Integer>
implements NumberAssert<S, Integer> {
    @VisibleForTesting
    Integers integers = Integers.instance();

    protected AbstractIntegerAssert(Integer actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S isEqualTo(int expected) {
        this.integers.assertEqual(this.info, this.actual, expected);
        return (S)((AbstractIntegerAssert)this.myself);
    }

    public S isNotEqualTo(int other) {
        this.integers.assertNotEqual(this.info, this.actual, other);
        return (S)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public S isZero() {
        this.integers.assertIsZero(this.info, (Comparable)this.actual);
        return (S)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public S isNotZero() {
        this.integers.assertIsNotZero(this.info, (Comparable)this.actual);
        return (S)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public S isPositive() {
        this.integers.assertIsPositive(this.info, (Comparable)this.actual);
        return (S)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public S isNegative() {
        this.integers.assertIsNegative(this.info, (Comparable)this.actual);
        return (S)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public S isNotNegative() {
        this.integers.assertIsNotNegative(this.info, (Comparable)this.actual);
        return (S)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public S isNotPositive() {
        this.integers.assertIsNotPositive(this.info, (Comparable)this.actual);
        return (S)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public S isLessThan(int other) {
        this.integers.assertLessThan(this.info, (Comparable)this.actual, other);
        return (S)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public S isLessThanOrEqualTo(int other) {
        this.integers.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (S)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public S isGreaterThan(int other) {
        this.integers.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return (S)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public S isGreaterThanOrEqualTo(int other) {
        this.integers.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (S)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public S isBetween(Integer start, Integer end) {
        this.integers.assertIsBetween(this.info, (Comparable)this.actual, start, end);
        return (S)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public S isStrictlyBetween(Integer start, Integer end) {
        this.integers.assertIsStrictlyBetween(this.info, (Comparable)this.actual, start, end);
        return (S)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public S isCloseTo(int expected, Offset<Integer> offset) {
        this.integers.assertIsCloseTo(this.info, (Integer)this.actual, expected, offset);
        return (S)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public S isCloseTo(Integer expected, Offset<Integer> offset) {
        this.integers.assertIsCloseTo(this.info, (Integer)this.actual, expected, offset);
        return (S)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public S usingComparator(Comparator<? super Integer> customComparator) {
        super.usingComparator(customComparator);
        this.integers = new Integers(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public S usingDefaultComparator() {
        super.usingDefaultComparator();
        this.integers = Integers.instance();
        return (S)((AbstractIntegerAssert)this.myself);
    }
}

