/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.data;

import java.util.Map;
import org.assertj.core.presentation.DefaultToString;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.Objects;

public class MapEntry<K, V>
implements Map.Entry<K, V> {
    public final K key;
    public final V value;

    public static <K, V> MapEntry<K, V> entry(K key, V value) {
        return new MapEntry<K, V>(key, value);
    }

    private MapEntry(K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapEntry)) {
            return false;
        }
        MapEntry other = (MapEntry)obj;
        return Objects.areEqual(this.key, other.key) && Objects.areEqual(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCodeFor(this.key);
        result = 31 * result + Objects.hashCodeFor(this.value);
        return result;
    }

    public String toString() {
        return DefaultToString.toStringOf(this, (Representation)StandardRepresentation.STANDARD_REPRESENTATION);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException();
    }
}

