/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractBigDecimalAssert;
import org.assertj.core.api.AbstractBooleanArrayAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractByteAssert;
import org.assertj.core.api.AbstractCharArrayAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractCharacterAssert;
import org.assertj.core.api.AbstractClassAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractDateAssert;
import org.assertj.core.api.AbstractDoubleArrayAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.AbstractFloatArrayAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractInputStreamAssert;
import org.assertj.core.api.AbstractIntArrayAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractLongArrayAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractPathAssert;
import org.assertj.core.api.AbstractShortArrayAssert;
import org.assertj.core.api.AbstractShortAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertDelegateTarget;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.BigDecimalAssert;
import org.assertj.core.api.BooleanArrayAssert;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.ByteArrayAssert;
import org.assertj.core.api.ByteAssert;
import org.assertj.core.api.CharArrayAssert;
import org.assertj.core.api.CharSequenceAssert;
import org.assertj.core.api.CharacterAssert;
import org.assertj.core.api.ClassAssert;
import org.assertj.core.api.Condition;
import org.assertj.core.api.DateAssert;
import org.assertj.core.api.DoubleArrayAssert;
import org.assertj.core.api.DoubleAssert;
import org.assertj.core.api.Fail;
import org.assertj.core.api.FileAssert;
import org.assertj.core.api.FloatArrayAssert;
import org.assertj.core.api.FloatAssert;
import org.assertj.core.api.GenericComparableAssert;
import org.assertj.core.api.InputStreamAssert;
import org.assertj.core.api.IntArrayAssert;
import org.assertj.core.api.IntegerAssert;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.LongArrayAssert;
import org.assertj.core.api.LongAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.PathAssert;
import org.assertj.core.api.ShortArrayAssert;
import org.assertj.core.api.ShortAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.api.filter.Filters;
import org.assertj.core.condition.AllOf;
import org.assertj.core.condition.AnyOf;
import org.assertj.core.condition.DoesNotHave;
import org.assertj.core.condition.Not;
import org.assertj.core.data.Index;
import org.assertj.core.data.MapEntry;
import org.assertj.core.data.Offset;
import org.assertj.core.groups.Properties;
import org.assertj.core.groups.Tuple;
import org.assertj.core.util.Files;
import org.assertj.core.util.introspection.FieldSupport;

public class Assertions {
    public static AbstractBigDecimalAssert<?> assertThat(BigDecimal actual) {
        return new BigDecimalAssert(actual);
    }

    public static AbstractBooleanAssert<?> assertThat(boolean actual) {
        return new BooleanAssert(actual);
    }

    public static AbstractBooleanAssert<?> assertThat(Boolean actual) {
        return new BooleanAssert(actual);
    }

    public static AbstractBooleanArrayAssert<?> assertThat(boolean[] actual) {
        return new BooleanArrayAssert(actual);
    }

    public static AbstractByteAssert<?> assertThat(byte actual) {
        return new ByteAssert(actual);
    }

    public static AbstractByteAssert<?> assertThat(Byte actual) {
        return new ByteAssert(actual);
    }

    public static AbstractByteArrayAssert<?> assertThat(byte[] actual) {
        return new ByteArrayAssert(actual);
    }

    public static AbstractCharacterAssert<?> assertThat(char actual) {
        return new CharacterAssert(Character.valueOf(actual));
    }

    public static AbstractCharArrayAssert<?> assertThat(char[] actual) {
        return new CharArrayAssert(actual);
    }

    public static AbstractCharacterAssert<?> assertThat(Character actual) {
        return new CharacterAssert(actual);
    }

    public static AbstractClassAssert<?> assertThat(Class<?> actual) {
        return new ClassAssert(actual);
    }

    public static <T extends Comparable<? super T>> AbstractComparableAssert<?, T> assertThat(T actual) {
        return new GenericComparableAssert<T>(actual);
    }

    public static <T> AbstractIterableAssert<?, ? extends Iterable<? extends T>, T> assertThat(Iterable<? extends T> actual) {
        return new IterableAssert<T>(actual);
    }

    public static <T> AbstractIterableAssert<?, ? extends Iterable<? extends T>, T> assertThat(Iterator<? extends T> actual) {
        return new IterableAssert<T>(actual);
    }

    public static AbstractDoubleAssert<?> assertThat(double actual) {
        return new DoubleAssert(actual);
    }

    public static AbstractDoubleAssert<?> assertThat(Double actual) {
        return new DoubleAssert(actual);
    }

    public static AbstractDoubleArrayAssert<?> assertThat(double[] actual) {
        return new DoubleArrayAssert(actual);
    }

    public static AbstractFileAssert<?> assertThat(File actual) {
        return new FileAssert(actual);
    }

    public static AbstractPathAssert<?> assertThat(Path actual) {
        return new PathAssert(actual);
    }

    public static AbstractInputStreamAssert<?, ? extends InputStream> assertThat(InputStream actual) {
        return new InputStreamAssert(actual);
    }

    public static AbstractFloatAssert<?> assertThat(float actual) {
        return new FloatAssert(Float.valueOf(actual));
    }

    public static AbstractFloatAssert<?> assertThat(Float actual) {
        return new FloatAssert(actual);
    }

    public static AbstractFloatArrayAssert<?> assertThat(float[] actual) {
        return new FloatArrayAssert(actual);
    }

    public static AbstractIntegerAssert<?> assertThat(int actual) {
        return new IntegerAssert(actual);
    }

    public static AbstractIntArrayAssert<?> assertThat(int[] actual) {
        return new IntArrayAssert(actual);
    }

    public static AbstractIntegerAssert<?> assertThat(Integer actual) {
        return new IntegerAssert(actual);
    }

    public static <T> AbstractListAssert<?, ? extends List<? extends T>, T> assertThat(List<? extends T> actual) {
        return new ListAssert<T>(actual);
    }

    public static AbstractLongAssert<?> assertThat(long actual) {
        return new LongAssert(actual);
    }

    public static AbstractLongAssert<?> assertThat(Long actual) {
        return new LongAssert(actual);
    }

    public static AbstractLongArrayAssert<?> assertThat(long[] actual) {
        return new LongArrayAssert(actual);
    }

    public static <T> AbstractObjectAssert<?, T> assertThat(T actual) {
        return new ObjectAssert<T>(actual);
    }

    public static <T extends AssertDelegateTarget> T assertThat(T assertion) {
        return assertion;
    }

    public static <T> T assertThat(AssertProvider<T> component) {
        return component.assertThat();
    }

    public static <T> AbstractObjectArrayAssert<?, T> assertThat(T[] actual) {
        return new ObjectArrayAssert<T>(actual);
    }

    public static <K, V> MapAssert<K, V> assertThat(Map<K, V> actual) {
        return new MapAssert<K, V>(actual);
    }

    public static AbstractShortAssert<?> assertThat(short actual) {
        return new ShortAssert(actual);
    }

    public static AbstractShortAssert<?> assertThat(Short actual) {
        return new ShortAssert(actual);
    }

    public static AbstractShortArrayAssert<?> assertThat(short[] actual) {
        return new ShortArrayAssert(actual);
    }

    public static AbstractCharSequenceAssert<?, ? extends CharSequence> assertThat(CharSequence actual) {
        return new CharSequenceAssert(actual);
    }

    public static AbstractCharSequenceAssert<?, String> assertThat(String actual) {
        return new StringAssert(actual);
    }

    public static AbstractDateAssert<?> assertThat(Date actual) {
        return new DateAssert(actual);
    }

    public static AbstractThrowableAssert<?, ? extends Throwable> assertThat(Throwable actual) {
        return new ThrowableAssert(actual);
    }

    public static AbstractThrowableAssert<?, ? extends Throwable> assertThatThrownBy(ThrowableAssert.ThrowingCallable shouldRaiseThrowable) {
        return new ThrowableAssert(Assertions.catchThrowable(shouldRaiseThrowable)).hasBeenThrown();
    }

    public static Throwable catchThrowable(ThrowableAssert.ThrowingCallable shouldRaiseThrowable) {
        return ThrowableAssert.catchThrowable(shouldRaiseThrowable);
    }

    public static void setRemoveAssertJRelatedElementsFromStackTrace(boolean removeAssertJRelatedElementsFromStackTrace) {
        Fail.setRemoveAssertJRelatedElementsFromStackTrace(removeAssertJRelatedElementsFromStackTrace);
    }

    public static void fail(String failureMessage) {
        Fail.fail(failureMessage);
    }

    public static void fail(String failureMessage, Throwable realCause) {
        Fail.fail(failureMessage, realCause);
    }

    public static void failBecauseExceptionWasNotThrown(Class<? extends Throwable> exceptionClass) {
        Fail.shouldHaveThrown(exceptionClass);
    }

    public static void shouldHaveThrown(Class<? extends Throwable> exceptionClass) {
        Fail.shouldHaveThrown(exceptionClass);
    }

    public static <T> Properties<T> extractProperty(String propertyName, Class<T> propertyType) {
        return Properties.extractProperty(propertyName, propertyType);
    }

    public static Properties<Object> extractProperty(String propertyName) {
        return Properties.extractProperty(propertyName);
    }

    public static Tuple tuple(Object ... values) {
        return Tuple.tuple(values);
    }

    public static void setAllowExtractingPrivateFields(boolean allowExtractingPrivateFields) {
        FieldSupport.extraction().setAllowUsingPrivateFields(allowExtractingPrivateFields);
    }

    public static void setAllowComparingPrivateFields(boolean allowComparingPrivateFields) {
        FieldSupport.comparison().setAllowUsingPrivateFields(allowComparingPrivateFields);
    }

    public static <K, V> MapEntry<K, V> entry(K key, V value) {
        return MapEntry.entry(key, value);
    }

    public static Index atIndex(int index) {
        return Index.atIndex(index);
    }

    public static Offset<Double> offset(Double value) {
        return Offset.offset(value);
    }

    public static Offset<Float> offset(Float value) {
        return Offset.offset(value);
    }

    public static Offset<Double> within(Double value) {
        return Offset.offset(value);
    }

    public static Offset<Float> within(Float value) {
        return Offset.offset(value);
    }

    public static Offset<BigDecimal> within(BigDecimal value) {
        return Offset.offset(value);
    }

    @SafeVarargs
    public static <T> Condition<T> allOf(Condition<? super T> ... conditions) {
        return AllOf.allOf(conditions);
    }

    public static <T> Condition<T> allOf(Iterable<? extends Condition<? super T>> conditions) {
        return AllOf.allOf(conditions);
    }

    @SafeVarargs
    public static <T> Condition<T> anyOf(Condition<? super T> ... conditions) {
        return AnyOf.anyOf(conditions);
    }

    public static <T> Condition<T> anyOf(Iterable<? extends Condition<? super T>> conditions) {
        return AnyOf.anyOf(conditions);
    }

    public static <T> DoesNotHave<T> doesNotHave(Condition<? super T> condition) {
        return DoesNotHave.doesNotHave(condition);
    }

    public static <T> Not<T> not(Condition<? super T> condition) {
        return Not.not(condition);
    }

    public static <E> Filters<E> filter(E[] array) {
        return Filters.filter(array);
    }

    public static <E> Filters<E> filter(Iterable<E> iterableToFilter) {
        return Filters.filter(iterableToFilter);
    }

    public static String contentOf(File file, Charset charset) {
        return Files.contentOf(file, charset);
    }

    public static String contentOf(File file, String charsetName) {
        return Files.contentOf(file, charsetName);
    }

    public static String contentOf(File file) {
        return Files.contentOf(file, Charset.defaultCharset());
    }

    public static List<String> linesOf(File file) {
        return Files.linesOf(file, Charset.defaultCharset());
    }

    public static List<String> linesOf(File file, Charset charset) {
        return Files.linesOf(file, charset);
    }

    public static List<String> linesOf(File file, String charsetName) {
        return Files.linesOf(file, charsetName);
    }

    public static void registerCustomDateFormat(DateFormat userCustomDateFormat) {
        AbstractDateAssert.registerCustomDateFormat(userCustomDateFormat);
    }

    public static void registerCustomDateFormat(String userCustomDateFormatPattern) {
        AbstractDateAssert.registerCustomDateFormat(userCustomDateFormatPattern);
    }

    public static void useDefaultDateFormatsOnly() {
        AbstractDateAssert.useDefaultDateFormatsOnly();
    }

    protected Assertions() {
    }
}

