/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.util.ArrayWrapperList;
import org.assertj.core.util.Iterables;
import org.assertj.core.util.introspection.FieldUtils;
import org.assertj.core.util.introspection.IntrospectionError;

public class FieldSupport {
    private static final String SEPARATOR = ".";
    private static final FieldSupport INSTANCE = new FieldSupport(true);
    private boolean allowExtractingPrivateFields;

    public static FieldSupport instance() {
        return INSTANCE;
    }

    public FieldSupport(boolean allowExtractingPrivateFields) {
        this.allowExtractingPrivateFields = allowExtractingPrivateFields;
    }

    public static void setAllowExtractingPrivateFields(boolean allowExtractingPrivateFields) {
        FieldSupport.INSTANCE.allowExtractingPrivateFields = allowExtractingPrivateFields;
    }

    public <T> List<T> fieldValues(String fieldName, Class<T> fieldClass, Iterable<?> target) {
        if (Iterables.isNullOrEmpty(target)) {
            return Collections.emptyList();
        }
        if (this.isNestedField(fieldName)) {
            String firstFieldName = this.popFieldNameFrom(fieldName);
            List<Object> fieldValues = this.fieldValues(firstFieldName, Object.class, target);
            return this.fieldValues(this.nextFieldNameFrom(fieldName), fieldClass, fieldValues);
        }
        return this.simpleFieldValues(fieldName, fieldClass, target);
    }

    public List<Object> fieldValues(String fieldName, Iterable<?> target) {
        return this.fieldValues(fieldName, Object.class, target);
    }

    public <T> List<T> fieldValues(String fieldName, Class<T> fieldClass, Object[] target) {
        return this.fieldValues(fieldName, fieldClass, ArrayWrapperList.wrap(target));
    }

    private <T> List<T> simpleFieldValues(String fieldName, Class<T> clazz, Iterable<?> target) {
        ArrayList<Object> fieldValues = new ArrayList<Object>();
        for (Object e : target) {
            fieldValues.add(e == null ? null : (Object)this.fieldValue(fieldName, clazz, e));
        }
        return Collections.unmodifiableList(fieldValues);
    }

    private String popFieldNameFrom(String fieldNameChain) {
        if (!this.isNestedField(fieldNameChain)) {
            return fieldNameChain;
        }
        return fieldNameChain.substring(0, fieldNameChain.indexOf(SEPARATOR));
    }

    private String nextFieldNameFrom(String fieldNameChain) {
        if (!this.isNestedField(fieldNameChain)) {
            return "";
        }
        return fieldNameChain.substring(fieldNameChain.indexOf(SEPARATOR) + 1);
    }

    private boolean isNestedField(String fieldName) {
        return fieldName.contains(SEPARATOR) && !fieldName.startsWith(SEPARATOR) && !fieldName.endsWith(SEPARATOR);
    }

    public <T> T fieldValue(String fieldName, Class<T> fieldClass, Object target) {
        if (target == null) {
            return null;
        }
        if (this.isNestedField(fieldName)) {
            String outerFieldName = this.popFieldNameFrom(fieldName);
            Object outerFieldValue = this.readSimpleField(outerFieldName, Object.class, target);
            return this.fieldValue(this.nextFieldNameFrom(fieldName), fieldClass, outerFieldValue);
        }
        return this.readSimpleField(fieldName, fieldClass, target);
    }

    private <T> T readSimpleField(String fieldName, Class<T> clazz, Object target) {
        try {
            Object readField = FieldUtils.readField(target, fieldName, this.allowExtractingPrivateFields);
            return clazz.cast(readField);
        }
        catch (ClassCastException e) {
            String msg = String.format("Unable to obtain the value of the field <'%s'> from <%s> - wrong field type specified <%s>", fieldName, target, clazz);
            throw new IntrospectionError(msg, e);
        }
        catch (IllegalAccessException iae) {
            String msg = String.format("Unable to obtain the value of the field <'%s'> from <%s>, check that field is public.", fieldName, target);
            throw new IntrospectionError(msg, iae);
        }
        catch (Throwable unexpected) {
            String msg = String.format("Unable to obtain the value of the field <'%s'> from <%s>", fieldName, target);
            throw new IntrospectionError(msg, unexpected);
        }
    }
}

