/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.Arrays;
import org.assertj.core.description.Description;
import org.assertj.core.description.EmptyTextDescription;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.error.MessageFormatter;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;

public class BasicErrorMessageFactory
implements ErrorMessageFactory {
    protected final String format;
    protected final Object[] arguments;
    @VisibleForTesting
    MessageFormatter formatter = MessageFormatter.instance();

    public BasicErrorMessageFactory(String format, Object ... arguments) {
        this.format = format;
        this.arguments = arguments;
    }

    @Override
    public String create(Description d, Representation representation) {
        return this.formatter.format(d, representation, this.format, this.arguments);
    }

    @Override
    public String create() {
        return this.formatter.format(EmptyTextDescription.emptyText(), new StandardRepresentation(), this.format, this.arguments);
    }

    protected static CharSequence unquotedString(String string) {
        return new UnquotedString(string);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicErrorMessageFactory other = (BasicErrorMessageFactory)obj;
        if (!Objects.areEqual(this.format, other.format)) {
            return false;
        }
        return Objects.areEqual(this.arguments, other.arguments);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCodeFor(this.format);
        result = 31 * result + Arrays.hashCode(this.arguments);
        return result;
    }

    public String toString() {
        return String.format("%s[format=%s, arguments=%s]", this.getClass().getSimpleName(), Strings.quote(this.format), org.assertj.core.util.Arrays.format(new StandardRepresentation(), this.arguments));
    }

    private static class UnquotedString
    implements CharSequence {
        private final String string;

        private UnquotedString(String string) {
            if (string == null) {
                throw new NullPointerException("string is mandatory");
            }
            this.string = string;
        }

        @Override
        public int length() {
            return this.string.length();
        }

        @Override
        public char charAt(int index) {
            return this.string.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.string.subSequence(start, end);
        }

        @Override
        public String toString() {
            return this.string;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.string == null ? 0 : this.string.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnquotedString other = (UnquotedString)obj;
            return !(this.string == null ? other.string != null : !this.string.equals(other.string));
        }
    }
}

