/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class Dates {
    private static final DateFormat ISO_DATE_FORMAT = Dates.newIsoDateFormat();
    private static final DateFormat ISO_DATE_TIME_FORMAT = Dates.newIsoDateTimeFormat();
    private static final DateFormat ISO_DATE_TIME_FORMAT_WITH_MS = Dates.newIsoDateTimeWithMsFormat();

    public static DateFormat newIsoDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static DateFormat newIsoDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    }

    public static DateFormat newIsoDateTimeWithMsFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    }

    public static synchronized String formatAsDatetime(Date date) {
        return date == null ? null : ISO_DATE_TIME_FORMAT.format(date);
    }

    public static synchronized String formatAsDatetimeWithMs(Date date) {
        return date == null ? null : ISO_DATE_TIME_FORMAT_WITH_MS.format(date);
    }

    public static String formatAsDatetime(Calendar calendar) {
        return calendar == null ? null : Dates.formatAsDatetime(calendar.getTime());
    }

    public static synchronized Date parse(String dateAsString) {
        try {
            return dateAsString == null ? null : ISO_DATE_FORMAT.parse(dateAsString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized Date parseDatetime(String dateAsString) {
        try {
            return dateAsString == null ? null : ISO_DATE_TIME_FORMAT.parse(dateAsString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized Date parseDatetimeWithMs(String dateAsString) {
        try {
            return dateAsString == null ? null : ISO_DATE_TIME_FORMAT_WITH_MS.parse(dateAsString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Calendar toCalendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static int yearOf(Date date) {
        return Dates.toCalendar(date).get(1);
    }

    public static int monthOf(Date date) {
        return Dates.toCalendar(date).get(2) + 1;
    }

    public static int dayOfMonthOf(Date date) {
        return Dates.toCalendar(date).get(5);
    }

    public static int dayOfWeekOf(Date date) {
        return Dates.toCalendar(date).get(7);
    }

    public static int hourOfDayOf(Date date) {
        return Dates.toCalendar(date).get(11);
    }

    public static int minuteOf(Date date) {
        return Dates.toCalendar(date).get(12);
    }

    public static int secondOf(Date date) {
        return Dates.toCalendar(date).get(13);
    }

    public static int millisecondOf(Date date) {
        return Dates.toCalendar(date).get(14);
    }

    public static long timeDifference(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("Expecting date parameter not to be null");
        }
        return Math.abs(date1.getTime() - date2.getTime());
    }

    public static Date truncateTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Dates.toCalendar(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date today() {
        return new Date();
    }

    public static Date yesterday() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date tomorrow() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        return cal.getTime();
    }

    public static String formatTimeDifference(Date date1, Date date2) {
        boolean notFirstDiff;
        long millisecondsDiff = Dates.timeDifference(date1, date2);
        long secondsDiff = millisecondsDiff / TimeUnit.SECONDS.toMillis(1L);
        long minutesDiff = millisecondsDiff / TimeUnit.MINUTES.toMillis(1L);
        long hoursDiff = millisecondsDiff / TimeUnit.HOURS.toMillis(1L);
        long daysDiff = millisecondsDiff / TimeUnit.DAYS.toMillis(1L);
        long hourFieldDiff = hoursDiff - TimeUnit.DAYS.toHours(daysDiff);
        long minuteFieldDiff = minutesDiff - TimeUnit.HOURS.toMinutes(hoursDiff);
        long secondFieldDiff = secondsDiff - TimeUnit.MINUTES.toSeconds(minutesDiff);
        long millisecondsFieldDiff = millisecondsDiff % TimeUnit.SECONDS.toMillis(1L);
        StringBuilder result = new StringBuilder();
        if (daysDiff > 0L) {
            result.append(String.format("%dd", daysDiff));
        }
        if (hourFieldDiff > 0L) {
            if (daysDiff > 0L && minuteFieldDiff == 0L && secondFieldDiff == 0L && millisecondsFieldDiff == 0L) {
                result.append(" and ");
            } else if (daysDiff > 0L) {
                result.append(" ");
            }
            result.append(String.format("%dh", hourFieldDiff));
        }
        if (minuteFieldDiff > 0L) {
            boolean bl = notFirstDiff = daysDiff > 0L || hourFieldDiff > 0L;
            if (notFirstDiff && secondFieldDiff == 0L && millisecondsFieldDiff == 0L) {
                result.append(" and ");
            } else if (notFirstDiff) {
                result.append(" ");
            }
            result.append(String.format("%dm", minuteFieldDiff));
        }
        if (secondFieldDiff > 0L) {
            boolean bl = notFirstDiff = daysDiff > 0L || hourFieldDiff > 0L || minuteFieldDiff > 0L;
            if (notFirstDiff && millisecondsFieldDiff == 0L) {
                result.append(" and ");
            } else if (notFirstDiff) {
                result.append(" ");
            }
            result.append(String.format("%ds", secondFieldDiff));
        }
        if (millisecondsFieldDiff > 0L) {
            if (result.length() > 0) {
                result.append(" and ");
            }
            result.append(String.format("%dms", millisecondsFieldDiff));
        }
        return result.toString();
    }
}

