/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.Date;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Dates;

public class ShouldBeBefore
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldBeBefore(Date actual, Date other, ComparisonStrategy comparisonStrategy) {
        return new ShouldBeBefore(actual, other, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldBeBefore(Date actual, Date other) {
        return new ShouldBeBefore(actual, other, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldBeBefore(Date actual, int year) {
        Date januaryTheFirstOfGivenYear = Dates.parse(year + "-01-01");
        return new ShouldBeBefore(actual, januaryTheFirstOfGivenYear, StandardComparisonStrategy.instance());
    }

    private ShouldBeBefore(Date actual, Date other, ComparisonStrategy comparisonStrategy) {
        super("\nExpecting:\n <%s>\nto be strictly before:\n <%s>%s", actual, other, comparisonStrategy);
    }
}

