/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.data.Index;
import org.assertj.core.data.Offset;
import org.assertj.core.internal.CommonErrors;

final class CommonValidations {
    private CommonValidations() {
    }

    static void checkIndexValueIsValid(Index index, int maximum) {
        if (index == null) {
            throw new NullPointerException("Index should not be null");
        }
        if (index.value <= maximum) {
            return;
        }
        String format = "Index should be between <%d> and <%d> (inclusive,) but was:\n <%d>";
        throw new IndexOutOfBoundsException(String.format(format, 0, maximum, index.value));
    }

    static void checkOffsetIsNotNull(Offset<?> offset) {
        if (offset == null) {
            throw new NullPointerException("The given offset should not be null");
        }
    }

    static void checkNumberIsNotNull(Number number) {
        if (number == null) {
            throw new NullPointerException("The given number should not be null");
        }
    }

    static void checkIsNotEmpty(Object[] values) {
        if (values.length == 0) {
            throw CommonErrors.arrayOfValuesToLookForIsEmpty();
        }
    }

    static void checkIsNotEmpty(Iterable<?> iterable) {
        if (!iterable.iterator().hasNext()) {
            throw CommonErrors.iterableOfValuesToLookForIsEmpty();
        }
    }

    static void checkIsNotNull(Object[] values) {
        if (values == null) {
            throw CommonErrors.arrayOfValuesToLookForIsNull();
        }
    }

    static void checkIsNotNull(Iterable<?> iterable) {
        if (iterable == null) {
            throw CommonErrors.iterableOfValuesForIsNull();
        }
    }

    static void checkIsNotNullAndNotEmpty(Object[] values) {
        CommonValidations.checkIsNotNull(values);
        CommonValidations.checkIsNotEmpty(values);
    }

    static void checkIsNotNullAndNotEmpty(Iterable<?> iterable) {
        CommonValidations.checkIsNotNull(iterable);
        CommonValidations.checkIsNotEmpty(iterable);
    }

    static void failIfEmptySinceActualIsNotEmpty(Object[] values) {
        if (values.length == 0) {
            throw new AssertionError((Object)"actual is not empty");
        }
    }
}

