/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.description.Description;
import org.assertj.core.error.AssertionErrorFactory;
import org.assertj.core.error.ConstructorInvoker;
import org.assertj.core.error.DescriptionFormatter;
import org.assertj.core.error.MessageFormatter;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Objects;
import org.assertj.core.util.ToString;
import org.assertj.core.util.VisibleForTesting;

public class ShouldBeEqual
implements AssertionErrorFactory {
    private static final String EXPECTED_BUT_WAS_MESSAGE = "\nExpecting:\n <%s>\nto be equal to:\n <%s>\nbut was not.";
    private static final String EXPECTED_BUT_WAS_MESSAGE_USING_COMPARATOR = "\nExpecting:\n <%s>\nto be equal to:\n <%s>\n%s but was not.";
    private static final Class<?>[] MSG_ARG_TYPES = new Class[]{String.class, String.class, String.class};
    @VisibleForTesting
    ConstructorInvoker constructorInvoker = new ConstructorInvoker();
    @VisibleForTesting
    final MessageFormatter messageFormatter = MessageFormatter.instance();
    @VisibleForTesting
    DescriptionFormatter descriptionFormatter = DescriptionFormatter.instance();
    protected final Object actual;
    protected final Object expected;
    private final ComparisonStrategy comparisonStrategy;

    public static AssertionErrorFactory shouldBeEqual(Object actual, Object expected) {
        return new ShouldBeEqual(actual, expected, StandardComparisonStrategy.instance());
    }

    public static AssertionErrorFactory shouldBeEqual(Object actual, Object expected, ComparisonStrategy comparisonStrategy) {
        return new ShouldBeEqual(actual, expected, comparisonStrategy);
    }

    @VisibleForTesting
    ShouldBeEqual(Object actual, Object expected, ComparisonStrategy comparisonStrategy) {
        this.actual = actual;
        this.expected = expected;
        this.comparisonStrategy = comparisonStrategy;
    }

    @Override
    public AssertionError newAssertionError(Description description) {
        AssertionError error;
        if (this.actualAndExpectedHaveSameStringRepresentation()) {
            return Failures.instance().failure(this.defaultDetailedErrorMessage(description));
        }
        if (this.isJUnitComparisonFailureRelevant() && (error = this.comparisonFailure(description)) != null) {
            return error;
        }
        return Failures.instance().failure(this.defaultErrorMessage(description));
    }

    private boolean isJUnitComparisonFailureRelevant() {
        return !(this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy);
    }

    private boolean actualAndExpectedHaveSameStringRepresentation() {
        return Objects.areEqual(ToString.toStringOf(this.actual), ToString.toStringOf(this.expected));
    }

    private String defaultErrorMessage(Description description) {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return this.messageFormatter.format(description, EXPECTED_BUT_WAS_MESSAGE_USING_COMPARATOR, this.actual, this.expected, this.comparisonStrategy);
        }
        return this.messageFormatter.format(description, EXPECTED_BUT_WAS_MESSAGE, this.expected, this.actual);
    }

    private String defaultDetailedErrorMessage(Description description) {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return this.messageFormatter.format(description, EXPECTED_BUT_WAS_MESSAGE_USING_COMPARATOR, this.detailedActual(), this.detailedExpected(), this.comparisonStrategy);
        }
        return this.messageFormatter.format(description, EXPECTED_BUT_WAS_MESSAGE, this.detailedExpected(), this.detailedActual());
    }

    private AssertionError comparisonFailure(Description description) {
        try {
            AssertionError comparisonFailure = this.newComparisonFailure(this.descriptionFormatter.format(description).trim());
            Failures.instance().removeAssertJRelatedElementsFromStackTraceIfNeeded(comparisonFailure);
            return comparisonFailure;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private AssertionError newComparisonFailure(String description) throws Exception {
        Object o = this.constructorInvoker.newInstance("org.junit.ComparisonFailure", MSG_ARG_TYPES, this.msgArgs(description));
        if (o instanceof AssertionError) {
            return (AssertionError)o;
        }
        return null;
    }

    private Object[] msgArgs(String description) {
        return Arrays.array(description, ToString.toStringOf(this.expected), ToString.toStringOf(this.actual));
    }

    private static String detailedToStringOf(Object obj) {
        return ToString.toStringOf(obj) + " (" + obj.getClass().getSimpleName() + "@" + Integer.toHexString(obj.hashCode()) + ")";
    }

    private String detailedActual() {
        return ShouldBeEqual.detailedToStringOf(this.actual);
    }

    private String detailedExpected() {
        return ShouldBeEqual.detailedToStringOf(this.expected);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ShouldBeEqual other = (ShouldBeEqual)o;
        if (!Objects.areEqual(this.actual, other.actual)) {
            return false;
        }
        return Objects.areEqual(this.expected, other.expected);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCodeFor(this.actual);
        result = 31 * result + Objects.hashCodeFor(this.expected);
        return result;
    }
}

