/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.DescriptionValidations;
import org.assertj.core.description.Description;
import org.assertj.core.util.Strings;

public class WritableAssertionInfo
implements AssertionInfo {
    private String overridingErrorMessage;
    private Description description;

    @Override
    public String overridingErrorMessage() {
        return this.overridingErrorMessage;
    }

    public void overridingErrorMessage(String newErrorMessage) {
        this.overridingErrorMessage = newErrorMessage;
    }

    @Override
    public Description description() {
        return this.description;
    }

    public String descriptionText() {
        return this.description != null ? this.description.value() : null;
    }

    public void description(String newDescription) {
        this.description = DescriptionValidations.checkIsNotNull(newDescription);
    }

    public void description(Description newDescription) {
        this.description = DescriptionValidations.checkIsNotNull(newDescription);
    }

    public String toString() {
        String format = "%s[overridingErrorMessage=%s, description=%s]";
        return String.format(format, this.getClass().getSimpleName(), Strings.quote(this.overridingErrorMessage()), Strings.quote(this.descriptionText()));
    }
}

