/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ArraySortedAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.EnumerableAssert;
import org.assertj.core.data.Index;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.LongArrays;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractLongArrayAssert<S extends AbstractLongArrayAssert<S>>
extends AbstractAssert<S, long[]>
implements EnumerableAssert<AbstractLongArrayAssert<S>, Long>,
ArraySortedAssert<AbstractLongArrayAssert<S>, Long> {
    @VisibleForTesting
    protected LongArrays arrays = LongArrays.instance();

    public AbstractLongArrayAssert(long[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (long[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (long[])this.actual);
    }

    @Override
    public S isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (long[])this.actual);
        return (S)((AbstractLongArrayAssert)this.myself);
    }

    @Override
    public S hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (long[])this.actual, expected);
        return (S)((AbstractLongArrayAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Object[] other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (long[])this.actual, other);
        return (S)((AbstractLongArrayAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (long[])this.actual, other);
        return (S)((AbstractLongArrayAssert)this.myself);
    }

    public S contains(long ... values) {
        this.arrays.assertContains(this.info, (long[])this.actual, values);
        return (S)((AbstractLongArrayAssert)this.myself);
    }

    public S containsOnly(long ... values) {
        this.arrays.assertContainsOnly(this.info, (long[])this.actual, values);
        return (S)((AbstractLongArrayAssert)this.myself);
    }

    public S containsOnlyOnce(long ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (long[])this.actual, values);
        return (S)((AbstractLongArrayAssert)this.myself);
    }

    public S containsSequence(long ... sequence) {
        this.arrays.assertContainsSequence(this.info, (long[])this.actual, sequence);
        return (S)((AbstractLongArrayAssert)this.myself);
    }

    public S contains(long value, Index index) {
        this.arrays.assertContains(this.info, (long[])this.actual, value, index);
        return (S)((AbstractLongArrayAssert)this.myself);
    }

    public S doesNotContain(long ... values) {
        this.arrays.assertDoesNotContain(this.info, (long[])this.actual, values);
        return (S)((AbstractLongArrayAssert)this.myself);
    }

    public S doesNotContain(long value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (long[])this.actual, value, index);
        return (S)((AbstractLongArrayAssert)this.myself);
    }

    public S doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (long[])this.actual);
        return (S)((AbstractLongArrayAssert)this.myself);
    }

    public S startsWith(long ... sequence) {
        this.arrays.assertStartsWith(this.info, (long[])this.actual, sequence);
        return (S)((AbstractLongArrayAssert)this.myself);
    }

    public S endsWith(long ... sequence) {
        this.arrays.assertEndsWith(this.info, (long[])this.actual, sequence);
        return (S)((AbstractLongArrayAssert)this.myself);
    }

    @Override
    public S isSorted() {
        this.arrays.assertIsSorted(this.info, (long[])this.actual);
        return (S)((AbstractLongArrayAssert)this.myself);
    }

    @Override
    public S isSortedAccordingTo(Comparator<? super Long> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (long[])this.actual, comparator);
        return (S)((AbstractLongArrayAssert)this.myself);
    }

    @Override
    public S usingElementComparator(Comparator<? super Long> customComparator) {
        this.arrays = new LongArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractLongArrayAssert)this.myself);
    }

    @Override
    public S usingDefaultElementComparator() {
        this.arrays = LongArrays.instance();
        return (S)((AbstractLongArrayAssert)this.myself);
    }

    public S containsExactly(long ... values) {
        this.objects.assertEqual(this.info, this.actual, values);
        return (S)((AbstractLongArrayAssert)this.myself);
    }
}

