/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ArraySortedAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.EnumerableAssert;
import org.assertj.core.data.Index;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.IntArrays;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractIntArrayAssert<S extends AbstractIntArrayAssert<S>>
extends AbstractAssert<S, int[]>
implements EnumerableAssert<AbstractIntArrayAssert<S>, Integer>,
ArraySortedAssert<AbstractIntArrayAssert<S>, Integer> {
    @VisibleForTesting
    protected IntArrays arrays = IntArrays.instance();

    public AbstractIntArrayAssert(int[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (int[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (int[])this.actual);
    }

    @Override
    public S isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (int[])this.actual);
        return (S)((AbstractIntArrayAssert)this.myself);
    }

    @Override
    public S hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (int[])this.actual, expected);
        return (S)((AbstractIntArrayAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Object[] other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (int[])this.actual, other);
        return (S)((AbstractIntArrayAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (int[])this.actual, other);
        return (S)((AbstractIntArrayAssert)this.myself);
    }

    public S contains(int ... values) {
        this.arrays.assertContains(this.info, (int[])this.actual, values);
        return (S)((AbstractIntArrayAssert)this.myself);
    }

    public S containsOnly(int ... values) {
        this.arrays.assertContainsOnly(this.info, (int[])this.actual, values);
        return (S)((AbstractIntArrayAssert)this.myself);
    }

    public S containsOnlyOnce(int ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (int[])this.actual, values);
        return (S)((AbstractIntArrayAssert)this.myself);
    }

    public S containsSequence(int ... sequence) {
        this.arrays.assertContainsSequence(this.info, (int[])this.actual, sequence);
        return (S)((AbstractIntArrayAssert)this.myself);
    }

    public S contains(int value, Index index) {
        this.arrays.assertContains(this.info, (int[])this.actual, value, index);
        return (S)((AbstractIntArrayAssert)this.myself);
    }

    public S doesNotContain(int ... values) {
        this.arrays.assertDoesNotContain(this.info, (int[])this.actual, values);
        return (S)((AbstractIntArrayAssert)this.myself);
    }

    public S doesNotContain(int value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (int[])this.actual, value, index);
        return (S)((AbstractIntArrayAssert)this.myself);
    }

    public S doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (int[])this.actual);
        return (S)((AbstractIntArrayAssert)this.myself);
    }

    public S startsWith(int ... sequence) {
        this.arrays.assertStartsWith(this.info, (int[])this.actual, sequence);
        return (S)((AbstractIntArrayAssert)this.myself);
    }

    public S endsWith(int ... sequence) {
        this.arrays.assertEndsWith(this.info, (int[])this.actual, sequence);
        return (S)((AbstractIntArrayAssert)this.myself);
    }

    @Override
    public S isSorted() {
        this.arrays.assertIsSorted(this.info, (int[])this.actual);
        return (S)((AbstractIntArrayAssert)this.myself);
    }

    @Override
    public S isSortedAccordingTo(Comparator<? super Integer> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (int[])this.actual, comparator);
        return (S)((AbstractIntArrayAssert)this.myself);
    }

    @Override
    public S usingElementComparator(Comparator<? super Integer> customComparator) {
        this.arrays = new IntArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractIntArrayAssert)this.myself);
    }

    @Override
    public S usingDefaultElementComparator() {
        this.arrays = IntArrays.instance();
        return (S)((AbstractIntArrayAssert)this.myself);
    }

    public S containsExactly(int ... values) {
        this.objects.assertEqual(this.info, this.actual, values);
        return (S)((AbstractIntArrayAssert)this.myself);
    }
}

