/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ArraySortedAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.EnumerableAssert;
import org.assertj.core.data.Index;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.FloatArrays;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractFloatArrayAssert<S extends AbstractFloatArrayAssert<S>>
extends AbstractAssert<S, float[]>
implements EnumerableAssert<AbstractFloatArrayAssert<S>, Float>,
ArraySortedAssert<AbstractFloatArrayAssert<S>, Float> {
    @VisibleForTesting
    protected FloatArrays arrays = FloatArrays.instance();

    public AbstractFloatArrayAssert(float[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (float[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (float[])this.actual);
    }

    @Override
    public S isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (float[])this.actual);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public S hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (float[])this.actual, expected);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Object[] other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (float[])this.actual, other);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (float[])this.actual, other);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S contains(float ... values) {
        this.arrays.assertContains(this.info, (float[])this.actual, values);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S containsOnly(float ... values) {
        this.arrays.assertContainsOnly(this.info, (float[])this.actual, values);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S containsOnlyOnce(float ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (float[])this.actual, values);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S containsSequence(float ... sequence) {
        this.arrays.assertContainsSequence(this.info, (float[])this.actual, sequence);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S contains(float value, Index index) {
        this.arrays.assertContains(this.info, (float[])this.actual, value, index);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S doesNotContain(float ... values) {
        this.arrays.assertDoesNotContain(this.info, (float[])this.actual, values);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S doesNotContain(float value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (float[])this.actual, value, index);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (float[])this.actual);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S startsWith(float ... sequence) {
        this.arrays.assertStartsWith(this.info, (float[])this.actual, sequence);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S endsWith(float ... sequence) {
        this.arrays.assertEndsWith(this.info, (float[])this.actual, sequence);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public S isSorted() {
        this.arrays.assertIsSorted(this.info, (float[])this.actual);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public S isSortedAccordingTo(Comparator<? super Float> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (float[])this.actual, comparator);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public S usingElementComparator(Comparator<? super Float> customComparator) {
        this.arrays = new FloatArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public S usingDefaultElementComparator() {
        this.arrays = FloatArrays.instance();
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S containsExactly(float ... values) {
        this.objects.assertEqual(this.info, this.actual, values);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }
}

