/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.util.Lists;

public final class Throwables {
    public static void appendStackTraceInCurentThreadToThrowable(Throwable t, String methodToStartFrom) {
        ArrayList<StackTraceElement> stackTrace = Lists.newArrayList(t.getStackTrace());
        stackTrace.addAll(Throwables.stackTraceInCurrentThread(methodToStartFrom));
        t.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
    }

    private static List<StackTraceElement> stackTraceInCurrentThread(String methodToStartFrom) {
        List<StackTraceElement> filtered = Throwables.stackTraceInCurrentThread();
        ArrayList<StackTraceElement> toRemove = new ArrayList<StackTraceElement>();
        for (StackTraceElement e : filtered) {
            if (methodToStartFrom.equals(e.getMethodName())) break;
            toRemove.add(e);
        }
        filtered.removeAll(toRemove);
        return filtered;
    }

    private static List<StackTraceElement> stackTraceInCurrentThread() {
        return Lists.newArrayList(Thread.currentThread().getStackTrace());
    }

    public static void removeAssertJRelatedElementsFromStackTrace(Throwable throwable) {
        ArrayList<StackTraceElement> filtered = Lists.newArrayList(throwable.getStackTrace());
        StackTraceElement previous = null;
        for (StackTraceElement element : throwable.getStackTrace()) {
            if (element.getClassName().contains("org.assert")) {
                filtered.remove(element);
                if (previous != null && previous.getClassName().equals("java.lang.reflect.Constructor") && element.getClassName().contains("org.assertj.core.error.ConstructorInvoker")) {
                    filtered.remove(previous);
                }
            }
            previous = element;
        }
        StackTraceElement[] newStackTrace = filtered.toArray(new StackTraceElement[filtered.size()]);
        throwable.setStackTrace(newStackTrace);
    }

    private Throwables() {
    }
}

