/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import org.assertj.core.util.Arrays;

public final class Strings {
    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    @Deprecated
    public static boolean isEmpty(String s) {
        return Strings.isNullOrEmpty(s);
    }

    public static String quote(String s) {
        return s != null ? Strings.concat("'", s, "'") : null;
    }

    public static Object quote(Object o) {
        return o instanceof String ? Strings.quote(o.toString()) : o;
    }

    public static String concat(Object ... objects) {
        if (Arrays.isNullOrEmpty(objects)) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (Object o : objects) {
            b.append(o);
        }
        return b.toString();
    }

    public static StringsToJoin join(String ... strings) {
        return new StringsToJoin(strings);
    }

    public static StringToAppend append(String toAppend) {
        return new StringToAppend(toAppend);
    }

    private Strings() {
    }

    public static class StringToAppend {
        private final String toAppend;

        StringToAppend(String toAppend) {
            this.toAppend = toAppend;
        }

        public String to(String s) {
            if (!s.endsWith(this.toAppend)) {
                return Strings.concat(s, this.toAppend);
            }
            return s;
        }
    }

    public static class StringsToJoin {
        private final String[] strings;

        StringsToJoin(String ... strings) {
            this.strings = strings;
        }

        public String with(String delimeter) {
            if (delimeter == null) {
                throw new IllegalArgumentException("Delimiter should not be null");
            }
            if (Arrays.isNullOrEmpty(this.strings)) {
                return "";
            }
            StringBuilder b = new StringBuilder();
            int stringCount = this.strings.length;
            for (int i = 0; i < stringCount; ++i) {
                String s = this.strings[i];
                b.append(s != null ? s : "");
                if (i >= stringCount - 1) continue;
                b.append(delimeter);
            }
            return b.toString();
        }
    }
}

