/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.lang.reflect.Array;
import org.assertj.core.util.Arrays;

public final class Objects {
    public static final int HASH_CODE_PRIME = 31;

    public static boolean areEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o1.equals(o2)) {
            return true;
        }
        return Objects.areEqualArrays(o1, o2);
    }

    private static boolean areEqualArrays(Object o1, Object o2) {
        if (!Arrays.isArray(o1) || !Arrays.isArray(o2)) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        int size = Array.getLength(o1);
        if (Array.getLength(o2) != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            Object e2;
            Object e1 = Array.get(o1, i);
            if (Objects.areEqual(e1, e2 = Array.get(o2, i))) continue;
            return false;
        }
        return true;
    }

    public static String[] namesOf(Class<?> ... types) {
        if (Arrays.isNullOrEmpty(types)) {
            return new String[0];
        }
        String[] names = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            names[i] = types[i].getName();
        }
        return names;
    }

    public static int hashCodeFor(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static <T> T castIfBelongsToType(Object o, Class<T> type) {
        if (o != null && type.isAssignableFrom(o.getClass())) {
            return type.cast(o);
        }
        return null;
    }

    private Objects() {
    }
}

