/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.assertj.core.util.ToString;

public final class Collections {
    public static <T> Collection<T> duplicatesFrom(Collection<T> c) {
        LinkedHashSet<T> duplicates = new LinkedHashSet<T>();
        if (Collections.isNullOrEmpty(c)) {
            return duplicates;
        }
        HashSet<T> noDuplicates = new HashSet<T>();
        for (T e : c) {
            if (noDuplicates.contains(e)) {
                duplicates.add(e);
                continue;
            }
            noDuplicates.add(e);
        }
        return duplicates;
    }

    public static boolean isNullOrEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static String format(Collection<?> c) {
        if (c == null) {
            return null;
        }
        Iterator<?> i = c.iterator();
        if (!i.hasNext()) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        while (true) {
            Object e;
            b.append((e = i.next()) == c ? "(this Collection)" : ToString.toStringOf(e));
            if (!i.hasNext()) {
                return b.append(']').toString();
            }
            b.append(", ");
        }
    }

    public static <T> List<T> nonNullElementsIn(Collection<T> c) {
        if (Collections.isNullOrEmpty(c)) {
            return java.util.Collections.emptyList();
        }
        ArrayList<T> nonNull = new ArrayList<T>();
        for (T element : c) {
            if (element == null) continue;
            nonNull.add(element);
        }
        return nonNull;
    }

    private Collections() {
    }
}

