/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldContainString;
import org.assertj.core.error.ShouldEndWith;
import org.assertj.core.error.ShouldHaveMessage;
import org.assertj.core.error.ShouldHaveNoCause;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.internal.Diff;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.VisibleForTesting;

public class Throwables {
    private static final Throwables INSTANCE = new Throwables();
    @VisibleForTesting
    Diff diff = new Diff();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Throwables instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Throwables() {
    }

    public void assertHasMessage(AssertionInfo info, Throwable actual, String message) {
        Throwables.assertNotNull(info, actual);
        if (org.assertj.core.util.Objects.areEqual(actual.getMessage(), message)) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveMessage.shouldHaveMessage(actual, message));
    }

    public void assertHasNoCause(AssertionInfo info, Throwable actual) {
        Throwables.assertNotNull(info, actual);
        Throwable actualCause = actual.getCause();
        if (actualCause == null) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveNoCause.shouldHaveNoCause(actual));
    }

    public void assertHasMessageStartingWith(AssertionInfo info, Throwable actual, String description) {
        Throwables.assertNotNull(info, actual);
        if (actual.getMessage() != null && actual.getMessage().startsWith(description)) {
            return;
        }
        throw this.failures.failure(info, ShouldStartWith.shouldStartWith(actual.getMessage(), description));
    }

    public void assertHasMessageContaining(AssertionInfo info, Throwable actual, String description) {
        Throwables.assertNotNull(info, actual);
        if (actual.getMessage() != null && actual.getMessage().contains(description)) {
            return;
        }
        throw this.failures.failure(info, ShouldContainString.shouldContain(actual.getMessage(), description));
    }

    public void assertHasMessageEndingWith(AssertionInfo info, Throwable actual, String description) {
        Throwables.assertNotNull(info, actual);
        if (actual.getMessage() != null && actual.getMessage().endsWith(description)) {
            return;
        }
        throw this.failures.failure(info, ShouldEndWith.shouldEndWith(actual.getMessage(), description));
    }

    private static void assertNotNull(AssertionInfo info, Throwable actual) {
        Objects.instance().assertNotNull(info, actual);
    }
}

