/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeEqualIgnoringCase;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldContainString;
import org.assertj.core.error.ShouldContainStringOnlyOnce;
import org.assertj.core.error.ShouldContainStringSequence;
import org.assertj.core.error.ShouldEndWith;
import org.assertj.core.error.ShouldHaveSameSizeAs;
import org.assertj.core.error.ShouldHaveSize;
import org.assertj.core.error.ShouldMatchPattern;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContainString;
import org.assertj.core.error.ShouldNotMatchPattern;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Iterables;
import org.assertj.core.util.VisibleForTesting;

public class Strings {
    private static final Strings INSTANCE = new Strings();
    @VisibleForTesting
    Failures failures = Failures.instance();
    private final ComparisonStrategy comparisonStrategy;

    public static Strings instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Strings() {
        this(StandardComparisonStrategy.instance());
    }

    public Strings(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
        }
        return null;
    }

    public void assertNullOrEmpty(AssertionInfo info, String actual) {
        if (actual == null || !Strings.hasContents(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeNullOrEmpty.shouldBeNullOrEmpty(actual));
    }

    public void assertEmpty(AssertionInfo info, String actual) {
        this.assertNotNull(info, actual);
        if (!Strings.hasContents(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEmpty.shouldBeEmpty(actual));
    }

    public void assertNotEmpty(AssertionInfo info, String actual) {
        this.assertNotNull(info, actual);
        if (Strings.hasContents(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeEmpty.shouldNotBeEmpty());
    }

    private static boolean hasContents(String s) {
        return s.length() > 0;
    }

    public void assertHasSize(AssertionInfo info, String actual, int expectedSize) {
        this.assertNotNull(info, actual);
        int sizeOfActual = actual.length();
        if (sizeOfActual == expectedSize) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveSize.shouldHaveSize(actual, sizeOfActual, expectedSize));
    }

    public void assertHasSameSizeAs(AssertionInfo info, String actual, Iterable<?> other) {
        int sizeOfOther;
        this.assertNotNull(info, actual);
        if (other == null) {
            throw new NullPointerException("The iterable to look for should not be null");
        }
        int sizeOfActual = actual.length();
        if (sizeOfActual == (sizeOfOther = Iterables.sizeOf(other))) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveSameSizeAs.shouldHaveSameSizeAs(actual, sizeOfActual, sizeOfOther));
    }

    public void assertHasSameSizeAs(AssertionInfo info, String actual, Object[] other) {
        int sizeOfOther;
        this.assertNotNull(info, actual);
        if (other == null) {
            throw CommonErrors.arrayOfValuesToLookForIsNull();
        }
        int sizeOfActual = actual.length();
        if (sizeOfActual == (sizeOfOther = Array.getLength(other))) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveSameSizeAs.shouldHaveSameSizeAs(actual, sizeOfActual, sizeOfOther));
    }

    public void assertContains(AssertionInfo info, String actual, String ... values) {
        this.assertNotNull(info, actual);
        this.checkIsNotNull(values);
        this.checkIsNotEmpty(values);
        this.checkSequenceIsNotNull(values[0]);
        LinkedHashSet<String> notFound = new LinkedHashSet<String>();
        for (String value : values) {
            if (this.stringContains(actual, value)) continue;
            notFound.add(value);
        }
        if (notFound.isEmpty()) {
            return;
        }
        if (notFound.size() == 1 && values.length == 1) {
            throw this.failures.failure(info, ShouldContainString.shouldContain(actual, values[0], this.comparisonStrategy));
        }
        throw this.failures.failure(info, ShouldContainString.shouldContain(actual, values, notFound, this.comparisonStrategy));
    }

    private void checkIsNotNull(String ... values) {
        if (values == null) {
            throw CommonErrors.arrayOfValuesToLookForIsNull();
        }
    }

    private void checkIsNotEmpty(String ... values) {
        if (values.length == 0) {
            throw CommonErrors.arrayOfValuesToLookForIsEmpty();
        }
    }

    private boolean stringContains(String actual, String sequence) {
        return this.comparisonStrategy.stringContains(actual, sequence);
    }

    public void assertContainsIgnoringCase(AssertionInfo info, String actual, String sequence) {
        this.checkSequenceIsNotNull(sequence);
        this.assertNotNull(info, actual);
        if (actual.toLowerCase().contains(sequence.toLowerCase())) {
            return;
        }
        throw this.failures.failure(info, ShouldContainString.shouldContainIgnoringCase(actual, sequence));
    }

    public void assertDoesNotContain(AssertionInfo info, String actual, String sequence) {
        this.checkSequenceIsNotNull(sequence);
        this.assertNotNull(info, actual);
        if (!this.stringContains(actual, sequence)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotContainString.shouldNotContain(actual, sequence, this.comparisonStrategy));
    }

    private void checkSequenceIsNotNull(String sequence) {
        if (sequence == null) {
            throw new NullPointerException("The sequence to look for should not be null");
        }
    }

    public void assertEqualsIgnoringCase(AssertionInfo info, String actual, String expected) {
        if (this.areEqualIgnoringCase(actual, expected)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqualIgnoringCase.shouldBeEqual(actual, expected));
    }

    private boolean areEqualIgnoringCase(String actual, String expected) {
        if (actual == null) {
            return expected == null;
        }
        return actual.equalsIgnoreCase(expected);
    }

    public void assertContainsOnlyOnce(AssertionInfo info, String actual, String sequence) {
        this.checkSequenceIsNotNull(sequence);
        this.assertNotNull(info, actual);
        int sequenceOccurencesInActual = this.countOccurences(sequence, actual);
        if (sequenceOccurencesInActual == 1) {
            return;
        }
        throw this.failures.failure(info, ShouldContainStringOnlyOnce.shouldContainOnlyOnce(actual, sequence, sequenceOccurencesInActual, this.comparisonStrategy));
    }

    private int countOccurences(String sequenceToSearch, String actual) {
        int occurences = 0;
        for (int i = 0; i <= actual.length() - sequenceToSearch.length(); ++i) {
            if (!this.comparisonStrategy.areEqual(actual.substring(i, i + sequenceToSearch.length()), sequenceToSearch)) continue;
            ++occurences;
        }
        return occurences;
    }

    public void assertStartsWith(AssertionInfo info, String actual, String prefix) {
        if (prefix == null) {
            throw new NullPointerException("The given prefix should not be null");
        }
        this.assertNotNull(info, actual);
        if (this.comparisonStrategy.stringStartsWith(actual, prefix)) {
            return;
        }
        throw this.failures.failure(info, ShouldStartWith.shouldStartWith(actual, prefix, this.comparisonStrategy));
    }

    public void assertEndsWith(AssertionInfo info, String actual, String suffix) {
        if (suffix == null) {
            throw new NullPointerException("The given suffix should not be null");
        }
        this.assertNotNull(info, actual);
        if (this.comparisonStrategy.stringEndsWith(actual, suffix)) {
            return;
        }
        throw this.failures.failure(info, ShouldEndWith.shouldEndWith(actual, suffix, this.comparisonStrategy));
    }

    public void assertMatches(AssertionInfo info, String actual, String regex) {
        this.checkRegexIsNotNull(regex);
        this.assertNotNull(info, actual);
        if (Pattern.matches(regex, actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldMatchPattern.shouldMatch(actual, regex));
    }

    public void assertDoesNotMatch(AssertionInfo info, String actual, String regex) {
        this.checkRegexIsNotNull(regex);
        if (actual == null || !Pattern.matches(regex, actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotMatchPattern.shouldNotMatch(actual, regex));
    }

    private void checkRegexIsNotNull(String regex) {
        if (regex == null) {
            throw this.patternToMatchIsNull();
        }
    }

    public void assertMatches(AssertionInfo info, String actual, Pattern pattern) {
        this.checkIsNotNull(pattern);
        this.assertNotNull(info, actual);
        if (pattern.matcher(actual).matches()) {
            return;
        }
        throw this.failures.failure(info, ShouldMatchPattern.shouldMatch(actual, pattern.pattern()));
    }

    public void assertDoesNotMatch(AssertionInfo info, String actual, Pattern pattern) {
        this.checkIsNotNull(pattern);
        if (actual == null || !pattern.matcher(actual).matches()) {
            return;
        }
        throw this.failures.failure(info, ShouldNotMatchPattern.shouldNotMatch(actual, pattern.pattern()));
    }

    private void checkIsNotNull(Pattern pattern) {
        if (pattern == null) {
            throw this.patternToMatchIsNull();
        }
    }

    private NullPointerException patternToMatchIsNull() {
        return new NullPointerException("The regular expression pattern to match should not be null");
    }

    private void assertNotNull(AssertionInfo info, String actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    public void assertContainsSequence(AssertionInfo info, String actual, String[] values) {
        this.assertNotNull(info, actual);
        this.checkIsNotNull(values);
        this.checkIsNotEmpty(values);
        this.checkSequenceIsNotNull(values[0]);
        LinkedHashSet<String> notFound = new LinkedHashSet<String>();
        for (String value : values) {
            if (this.stringContains(actual, value)) continue;
            notFound.add(value);
        }
        if (notFound.isEmpty()) {
            if (values.length == 1) {
                return;
            }
            for (int i = 1; i < values.length; ++i) {
                if (actual.indexOf(values[i - 1]) <= actual.indexOf(values[i])) continue;
                throw this.failures.failure(info, ShouldContainStringSequence.shouldContainSequence(actual, values, i - 1, this.comparisonStrategy));
            }
            return;
        }
        if (notFound.size() == 1 && values.length == 1) {
            throw this.failures.failure(info, ShouldContainString.shouldContain(actual, values[0], this.comparisonStrategy));
        }
        throw this.failures.failure(info, ShouldContainString.shouldContain(actual, values, notFound, this.comparisonStrategy));
    }
}

