/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Offset;
import org.assertj.core.error.ShouldBeEqualWithinOffset;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.RealNumbers;
import org.assertj.core.util.Objects;
import org.assertj.core.util.VisibleForTesting;

public class Doubles
extends RealNumbers<Double> {
    private static final Doubles INSTANCE = new Doubles();

    public static Doubles instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Doubles() {
    }

    public Doubles(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    @Override
    protected Double zero() {
        return 0.0;
    }

    @Override
    protected Double NaN() {
        return Double.NaN;
    }

    public void assertEqual(AssertionInfo info, Double actual, Double expected, Offset<Double> offset) {
        CommonValidations.checkOffsetIsNotNull(offset);
        CommonValidations.checkNumberIsNotNull(expected);
        Doubles.assertNotNull(info, actual);
        if (Objects.areEqual(actual, expected)) {
            return;
        }
        if (expected != null && this.isEqualTo(actual, expected, offset)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqualWithinOffset.shouldBeEqual(actual, expected, offset, Math.abs(expected - actual)));
    }

    @Override
    protected boolean isEqualTo(Double actual, Double expected, Offset<?> offset) {
        return Math.abs(expected - actual) <= ((Number)offset.value).doubleValue();
    }
}

