/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.StandardComparisonStrategy;

public class ShouldContainStringOnlyOnce
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldContainOnlyOnce(String actual, String sequence, int occurences, ComparisonStrategy comparisonStrategy) {
        if (occurences == 0) {
            return new ShouldContainStringOnlyOnce(actual, sequence, comparisonStrategy);
        }
        return new ShouldContainStringOnlyOnce(actual, sequence, occurences, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldContainOnlyOnce(String actual, String sequence, int occurences) {
        if (occurences == 0) {
            return new ShouldContainStringOnlyOnce(actual, sequence, StandardComparisonStrategy.instance());
        }
        return new ShouldContainStringOnlyOnce(actual, sequence, occurences, StandardComparisonStrategy.instance());
    }

    private ShouldContainStringOnlyOnce(String actual, String expected, int occurences, ComparisonStrategy comparisonStrategy) {
        super("expecting:\n<%s>\n to appear only once in:\n<%s>\n but it appeared %s times%s.", expected, actual, occurences, comparisonStrategy);
    }

    private ShouldContainStringOnlyOnce(String actual, String expected, ComparisonStrategy comparisonStrategy) {
        super("expecting:\n<%s>\n to appear only once in:\n<%s>\n but it did not appear%s.", expected, actual, comparisonStrategy);
    }
}

