/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.Arrays;
import org.assertj.core.description.Description;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.error.MessageFormatter;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;

public class BasicErrorMessageFactory
implements ErrorMessageFactory {
    protected final String format;
    protected final Object[] arguments;
    @VisibleForTesting
    MessageFormatter formatter = MessageFormatter.instance();

    public BasicErrorMessageFactory(String format, Object ... arguments) {
        this.format = format;
        this.arguments = arguments;
    }

    @Override
    public String create(Description d) {
        return this.formatter.format(d, this.format, this.arguments);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicErrorMessageFactory other = (BasicErrorMessageFactory)obj;
        if (!Objects.areEqual(this.format, other.format)) {
            return false;
        }
        return Objects.areEqual(this.arguments, other.arguments);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCodeFor(this.format);
        result = 31 * result + Arrays.hashCode(this.arguments);
        return result;
    }

    public String toString() {
        return String.format("%s[format=%s, arguments=%s]", this.getClass().getSimpleName(), Strings.quote(this.format), org.assertj.core.util.Arrays.format(this.arguments));
    }
}

