/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.NumberAssert;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Longs;
import org.assertj.core.util.VisibleForTesting;

public class LongAssert
extends AbstractComparableAssert<LongAssert, Long>
implements NumberAssert<Long> {
    @VisibleForTesting
    Longs longs = Longs.instance();

    protected LongAssert(Long actual) {
        super(actual, LongAssert.class);
    }

    @Override
    public LongAssert isEqualTo(long expected) {
        this.longs.assertEqual(this.info, this.actual, expected);
        return this;
    }

    @Override
    public LongAssert isNotEqualTo(long other) {
        this.longs.assertNotEqual(this.info, this.actual, other);
        return this;
    }

    public LongAssert isZero() {
        this.longs.assertIsZero(this.info, (Comparable)this.actual);
        return this;
    }

    public LongAssert isNotZero() {
        this.longs.assertIsNotZero(this.info, (Comparable)this.actual);
        return this;
    }

    public LongAssert isPositive() {
        this.longs.assertIsPositive(this.info, (Comparable)this.actual);
        return this;
    }

    public LongAssert isNegative() {
        this.longs.assertIsNegative(this.info, (Comparable)this.actual);
        return this;
    }

    public LongAssert isNotNegative() {
        this.longs.assertIsNotNegative(this.info, (Comparable)this.actual);
        return this;
    }

    public LongAssert isNotPositive() {
        this.longs.assertIsNotPositive(this.info, (Comparable)this.actual);
        return this;
    }

    @Override
    public LongAssert isLessThan(long other) {
        this.longs.assertLessThan(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public LongAssert isLessThanOrEqualTo(long other) {
        this.longs.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public LongAssert isGreaterThan(long other) {
        this.longs.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public LongAssert isGreaterThanOrEqualTo(long other) {
        this.longs.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public LongAssert usingComparator(Comparator<? super Long> customComparator) {
        super.usingComparator(customComparator);
        this.longs = new Longs(new ComparatorBasedComparisonStrategy(customComparator));
        return (LongAssert)this.myself;
    }

    @Override
    public LongAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.longs = Longs.instance();
        return (LongAssert)this.myself;
    }
}

