/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.NumberAssert;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Integers;
import org.assertj.core.util.VisibleForTesting;

public class IntegerAssert
extends AbstractComparableAssert<IntegerAssert, Integer>
implements NumberAssert<Integer> {
    @VisibleForTesting
    Integers integers = Integers.instance();

    protected IntegerAssert(Integer actual) {
        super(actual, IntegerAssert.class);
    }

    @Override
    public IntegerAssert isEqualTo(int expected) {
        this.integers.assertEqual(this.info, this.actual, expected);
        return this;
    }

    @Override
    public IntegerAssert isNotEqualTo(int other) {
        this.integers.assertNotEqual(this.info, this.actual, other);
        return this;
    }

    public IntegerAssert isZero() {
        this.integers.assertIsZero(this.info, (Comparable)this.actual);
        return this;
    }

    public IntegerAssert isNotZero() {
        this.integers.assertIsNotZero(this.info, (Comparable)this.actual);
        return this;
    }

    public IntegerAssert isPositive() {
        this.integers.assertIsPositive(this.info, (Comparable)this.actual);
        return this;
    }

    public IntegerAssert isNegative() {
        this.integers.assertIsNegative(this.info, (Comparable)this.actual);
        return this;
    }

    public IntegerAssert isNotNegative() {
        this.integers.assertIsNotNegative(this.info, (Comparable)this.actual);
        return this;
    }

    public IntegerAssert isNotPositive() {
        this.integers.assertIsNotPositive(this.info, (Comparable)this.actual);
        return this;
    }

    @Override
    public IntegerAssert isLessThan(int other) {
        this.integers.assertLessThan(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public IntegerAssert isLessThanOrEqualTo(int other) {
        this.integers.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public IntegerAssert isGreaterThan(int other) {
        this.integers.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public IntegerAssert isGreaterThanOrEqualTo(int other) {
        this.integers.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public IntegerAssert usingComparator(Comparator<? super Integer> customComparator) {
        super.usingComparator(customComparator);
        this.integers = new Integers(new ComparatorBasedComparisonStrategy(customComparator));
        return (IntegerAssert)this.myself;
    }

    @Override
    public IntegerAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.integers = Integers.instance();
        return (IntegerAssert)this.myself;
    }
}

