/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.internal.Characters;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public class CharacterAssert
extends AbstractComparableAssert<CharacterAssert, Character> {
    @VisibleForTesting
    Characters characters = Characters.instance();

    protected CharacterAssert(Character actual) {
        super(actual, CharacterAssert.class);
    }

    @Override
    public CharacterAssert isEqualTo(char expected) {
        this.characters.assertEqual(this.info, this.actual, Character.valueOf(expected));
        return this;
    }

    @Override
    public CharacterAssert isNotEqualTo(char other) {
        this.characters.assertNotEqual(this.info, this.actual, Character.valueOf(other));
        return this;
    }

    @Override
    public CharacterAssert isLessThan(char other) {
        this.characters.assertLessThan(this.info, (Comparable)this.actual, Character.valueOf(other));
        return this;
    }

    @Override
    public CharacterAssert isLessThanOrEqualTo(char other) {
        this.characters.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, Character.valueOf(other));
        return this;
    }

    @Override
    public CharacterAssert isGreaterThan(char other) {
        this.characters.assertGreaterThan(this.info, (Comparable)this.actual, Character.valueOf(other));
        return this;
    }

    @Override
    public CharacterAssert isGreaterThanOrEqualTo(char other) {
        this.characters.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, Character.valueOf(other));
        return this;
    }

    public CharacterAssert isLowerCase() {
        this.characters.assertLowerCase(this.info, (Character)this.actual);
        return this;
    }

    public CharacterAssert isUpperCase() {
        this.characters.assertUpperCase(this.info, (Character)this.actual);
        return this;
    }

    @Override
    public CharacterAssert usingComparator(Comparator<? super Character> customComparator) {
        super.usingComparator(customComparator);
        this.characters = new Characters(new ComparatorBasedComparisonStrategy(customComparator));
        return (CharacterAssert)this.myself;
    }

    @Override
    public CharacterAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.characters = Characters.instance();
        return (CharacterAssert)this.myself;
    }
}

