/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.math.BigDecimal;
import java.util.Comparator;
import org.assertj.core.api.AbstractUnevenComparableAssert;
import org.assertj.core.api.NumberAssert;
import org.assertj.core.internal.BigDecimals;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public class BigDecimalAssert
extends AbstractUnevenComparableAssert<BigDecimalAssert, BigDecimal>
implements NumberAssert<BigDecimal> {
    @VisibleForTesting
    BigDecimals bigDecimals = BigDecimals.instance();

    protected BigDecimalAssert(BigDecimal actual) {
        super(actual, BigDecimalAssert.class);
    }

    public BigDecimalAssert isZero() {
        this.bigDecimals.assertIsZero(this.info, (Comparable)this.actual);
        return (BigDecimalAssert)this.myself;
    }

    public BigDecimalAssert isNotZero() {
        this.bigDecimals.assertIsNotZero(this.info, (Comparable)this.actual);
        return (BigDecimalAssert)this.myself;
    }

    public BigDecimalAssert isPositive() {
        this.bigDecimals.assertIsPositive(this.info, (Comparable)this.actual);
        return (BigDecimalAssert)this.myself;
    }

    public BigDecimalAssert isNegative() {
        this.bigDecimals.assertIsNegative(this.info, (Comparable)this.actual);
        return (BigDecimalAssert)this.myself;
    }

    public BigDecimalAssert isNotPositive() {
        this.bigDecimals.assertIsNotPositive(this.info, (Comparable)this.actual);
        return this;
    }

    public BigDecimalAssert isNotNegative() {
        this.bigDecimals.assertIsNotNegative(this.info, (Comparable)this.actual);
        return this;
    }

    @Override
    public BigDecimalAssert isEqualTo(String expected) {
        return (BigDecimalAssert)super.isEqualTo(new BigDecimal(expected));
    }

    @Override
    public BigDecimalAssert isEqualByComparingTo(String expected) {
        return (BigDecimalAssert)super.isEqualByComparingTo(new BigDecimal(expected));
    }

    @Override
    public BigDecimalAssert usingComparator(Comparator<? super BigDecimal> customComparator) {
        super.usingComparator(customComparator);
        this.bigDecimals = new BigDecimals(new ComparatorBasedComparisonStrategy(customComparator));
        return (BigDecimalAssert)this.myself;
    }

    @Override
    public BigDecimalAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.bigDecimals = BigDecimals.instance();
        return (BigDecimalAssert)this.myself;
    }
}

