/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde;

import java.awt.Frame;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.aspectj.ajde.EditorAdapter;
import org.aspectj.ajde.IRuntimeProperties;
import org.aspectj.ajde.IUIBuildMessageHandler;
import org.aspectj.ajde.IconRegistry;
import org.aspectj.ajde.IdeUIAdapter;
import org.aspectj.ajde.core.AjCompiler;
import org.aspectj.ajde.core.IBuildProgressMonitor;
import org.aspectj.ajde.core.ICompilerConfiguration;
import org.aspectj.ajde.internal.BuildConfigListener;
import org.aspectj.ajde.internal.BuildConfigManager;
import org.aspectj.ajde.internal.LstBuildConfigManager;
import org.aspectj.ajde.ui.FileStructureView;
import org.aspectj.ajde.ui.StructureSearchManager;
import org.aspectj.ajde.ui.StructureViewManager;
import org.aspectj.ajde.ui.swing.BrowserViewManager;
import org.aspectj.ajde.ui.swing.OptionsFrame;
import org.aspectj.ajde.ui.swing.StructureViewPanel;
import org.aspectj.ajde.ui.swing.SwingTreeViewNodeFactory;
import org.aspectj.ajde.ui.swing.TreeViewBuildConfigEditor;
import org.aspectj.asm.AsmManager;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.Message;
import org.aspectj.util.LangUtil;
import org.aspectj.util.Reflection;

public class Ajde {
    protected static final Ajde INSTANCE = new Ajde();
    private BrowserViewManager viewManager = null;
    private IdeUIAdapter ideUIAdapter = null;
    private TreeViewBuildConfigEditor buildConfigEditor = null;
    private IconRegistry iconRegistry;
    private IRuntimeProperties runtimeProperties;
    private boolean initialized = false;
    private AsmManager asm;
    private OptionsFrame optionsFrame = null;
    private Frame rootFrame = null;
    private StructureViewPanel fileStructurePanel = null;
    private EditorAdapter editorAdapter;
    private StructureViewManager structureViewManager;
    private StructureSearchManager structureSearchManager;
    private final BuildConfigManager configurationManager;
    private ICompilerConfiguration compilerConfig;
    private IUIBuildMessageHandler uiBuildMsgHandler;
    private IBuildProgressMonitor buildProgressMonitor;
    private AjCompiler compiler;
    private final BuildConfigListener STRUCTURE_UPDATE_CONFIG_LISTENER = new BuildConfigListener(){

        @Override
        public void currConfigChanged(String configFilePath) {
            if (configFilePath != null) {
                Ajde.getDefault().asm.readStructureModel(configFilePath);
            }
        }

        @Override
        public void configsListUpdated(List configsList) {
        }
    };

    public AsmManager getModel() {
        return this.asm;
    }

    protected Ajde() {
        this.configurationManager = new LstBuildConfigManager();
    }

    public void init(ICompilerConfiguration compilerConfig, IUIBuildMessageHandler uiBuildMessageHandler, IBuildProgressMonitor monitor, EditorAdapter editorAdapter, IdeUIAdapter ideUIAdapter, IconRegistry iconRegistry, Frame rootFrame, IRuntimeProperties runtimeProperties, boolean useFileView) {
        try {
            Ajde.INSTANCE.compilerConfig = compilerConfig;
            Ajde.INSTANCE.uiBuildMsgHandler = uiBuildMessageHandler;
            Ajde.INSTANCE.buildProgressMonitor = monitor;
            Ajde.INSTANCE.asm = AsmManager.createNewStructureModel(Collections.emptyMap());
            Ajde.INSTANCE.iconRegistry = iconRegistry;
            Ajde.INSTANCE.ideUIAdapter = ideUIAdapter;
            Ajde.INSTANCE.buildConfigEditor = new TreeViewBuildConfigEditor();
            Ajde.INSTANCE.rootFrame = rootFrame;
            Ajde.INSTANCE.runtimeProperties = runtimeProperties;
            Ajde.INSTANCE.configurationManager.addListener(Ajde.INSTANCE.STRUCTURE_UPDATE_CONFIG_LISTENER);
            Ajde.INSTANCE.ideUIAdapter = ideUIAdapter;
            Ajde.INSTANCE.editorAdapter = editorAdapter;
            Ajde.INSTANCE.structureSearchManager = new StructureSearchManager();
            Ajde.INSTANCE.structureViewManager = new StructureViewManager(new SwingTreeViewNodeFactory(iconRegistry));
            if (useFileView) {
                FileStructureView structureView = this.structureViewManager.createViewForSourceFile(editorAdapter.getCurrFile(), this.structureViewManager.getDefaultViewProperties());
                this.structureViewManager.setDefaultFileView(structureView);
                this.fileStructurePanel = new StructureViewPanel(structureView);
            }
            this.viewManager = new BrowserViewManager();
            this.optionsFrame = new OptionsFrame(iconRegistry);
            this.initialized = true;
        }
        catch (Throwable t) {
            Message error = new Message("AJDE UI failed to initialize", IMessage.ABORT, t, null);
            this.uiBuildMsgHandler.handleMessage(error);
        }
    }

    public void showOptionsFrame() {
        int x = this.rootFrame.getWidth() / 2 + this.rootFrame.getX() - this.optionsFrame.getWidth() / 2;
        int y = this.rootFrame.getHeight() / 2 + this.rootFrame.getY() - this.optionsFrame.getHeight() / 2;
        this.optionsFrame.setLocation(x, y);
        this.optionsFrame.setVisible(true);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Thread runInSameVM() {
        final RunProperties props = new RunProperties(this.compilerConfig, this.runtimeProperties, this.uiBuildMsgHandler, this.rootFrame);
        if (!props.valid) {
            return null;
        }
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    Reflection.runMainInSameVM(props.classpath, props.mainClass, props.args);
                }
                catch (Throwable e) {
                    Message msg = new Message("Error running " + props.mainClass, IMessage.ERROR, e, null);
                    Ajde.this.uiBuildMsgHandler.handleMessage(msg);
                }
            }
        };
        Thread result = new Thread(runner, props.mainClass);
        result.start();
        return result;
    }

    public LangUtil.ProcessController runInNewVM() {
        final RunProperties props = new RunProperties(this.compilerConfig, this.runtimeProperties, this.uiBuildMsgHandler, this.rootFrame);
        if (!props.valid) {
            return null;
        }
        final StringBuffer command = new StringBuffer();
        LangUtil.ProcessController controller = new LangUtil.ProcessController(){

            public void doCompleting(Throwable thrown, int result) {
                String m;
                LangUtil.ProcessController.Thrown any = this.getThrown();
                if (!any.thrown && null == thrown && 0 == result) {
                    return;
                }
                String context = props.mainClass + " command \"" + command + "\"";
                if (null != thrown) {
                    m = "Exception running " + context;
                    Ajde.this.uiBuildMsgHandler.handleMessage(new Message(m, IMessage.ERROR, thrown, null));
                } else if (0 != result) {
                    m = "Result of running " + context;
                    Ajde.this.uiBuildMsgHandler.handleMessage(new Message(m, IMessage.ERROR, null, null));
                }
                if (null != any.fromInPipe) {
                    m = "Error processing input pipe for " + context;
                    Ajde.this.uiBuildMsgHandler.handleMessage(new Message(m, IMessage.ERROR, thrown, null));
                }
                if (null != any.fromOutPipe) {
                    m = "Error processing output pipe for " + context;
                    Ajde.this.uiBuildMsgHandler.handleMessage(new Message(m, IMessage.ERROR, thrown, null));
                }
                if (null != any.fromErrPipe) {
                    m = "Error processing error pipe for " + context;
                    Ajde.this.uiBuildMsgHandler.handleMessage(new Message(m, IMessage.ERROR, thrown, null));
                }
            }
        };
        controller = LangUtil.makeProcess(controller, props.classpath, props.mainClass, props.args);
        command.append(Arrays.asList(controller.getCommand()).toString());
        controller.start();
        return controller;
    }

    public void runBuildInSameThread(String configFile, boolean buildFresh) {
        AjCompiler c = this.getCompilerForConfigFile(configFile);
        if (c == null) {
            return;
        }
        if (buildFresh) {
            c.buildFresh();
        } else {
            c.build();
        }
    }

    public void runBuildInDifferentThread(String configFile, boolean buildFresh) {
        AjCompiler c = this.getCompilerForConfigFile(configFile);
        if (c == null) {
            return;
        }
        CompilerThread compilerThread = new CompilerThread(c, buildFresh);
        compilerThread.start();
    }

    public static Ajde getDefault() {
        return INSTANCE;
    }

    public BrowserViewManager getViewManager() {
        return this.viewManager;
    }

    public Frame getRootFrame() {
        return this.rootFrame;
    }

    public OptionsFrame getOptionsFrame() {
        return this.optionsFrame;
    }

    public IdeUIAdapter getIdeUIAdapter() {
        return this.ideUIAdapter;
    }

    public EditorAdapter getEditorAdapter() {
        return this.editorAdapter;
    }

    public TreeViewBuildConfigEditor getBuildConfigEditor() {
        return this.buildConfigEditor;
    }

    public StructureViewPanel getFileStructurePanel() {
        return this.fileStructurePanel;
    }

    public IconRegistry getIconRegistry() {
        return this.iconRegistry;
    }

    public StructureViewManager getStructureViewManager() {
        return this.structureViewManager;
    }

    public StructureSearchManager getStructureSearchManager() {
        return this.structureSearchManager;
    }

    public BuildConfigManager getBuildConfigManager() {
        return this.configurationManager;
    }

    public ICompilerConfiguration getCompilerConfig() {
        return this.compilerConfig;
    }

    public IUIBuildMessageHandler getMessageHandler() {
        return this.uiBuildMsgHandler;
    }

    public IBuildProgressMonitor getBuildProgressMonitor() {
        return this.buildProgressMonitor;
    }

    public AjCompiler getCompilerForConfigFile(String configFile) {
        if (configFile == null) {
            return null;
        }
        if (this.compiler == null || !this.compiler.getId().equals(configFile)) {
            if (this.compiler != null) {
                this.compiler.clearLastState();
            }
            this.getMessageHandler().reset();
            this.compiler = new AjCompiler(configFile, this.getCompilerConfig(), this.getBuildProgressMonitor(), this.getMessageHandler());
        }
        return this.compiler;
    }

    public AsmManager getModelForConfigFile(String configFile) {
        return this.compiler.getModel();
    }

    private static class RunProperties {
        final String mainClass;
        final String classpath;
        final String[] args;
        final boolean valid;
        private final Frame rootFrame;

        RunProperties(ICompilerConfiguration compilerConfig, IRuntimeProperties runtimeProperties, IUIBuildMessageHandler handler, Frame rootFrame) {
            LangUtil.throwIaxIfNull(runtimeProperties, "runtime properties");
            LangUtil.throwIaxIfNull(compilerConfig, "compiler configuration");
            LangUtil.throwIaxIfNull(handler, "handler");
            LangUtil.throwIaxIfNull(rootFrame, "rootFrame");
            String mainClass = null;
            String classpath = null;
            String[] args = null;
            boolean valid = false;
            this.rootFrame = rootFrame;
            mainClass = runtimeProperties.getClassToExecute();
            if (LangUtil.isEmpty(mainClass)) {
                this.showWarningMessage("No main class specified");
            } else {
                StringBuilder sb = new StringBuilder();
                List<File> outputDirs = compilerConfig.getOutputLocationManager().getAllOutputLocations();
                Iterator<File> iterator = outputDirs.iterator();
                while (iterator.hasNext()) {
                    File outputDir;
                    File dir = outputDir = iterator.next();
                    sb.append(dir.getAbsolutePath() + File.pathSeparator);
                }
                classpath = LangUtil.makeClasspath(null, compilerConfig.getClasspath(), sb.toString(), compilerConfig.getOutJar());
                if (LangUtil.isEmpty(classpath)) {
                    this.showWarningMessage("No classpath specified");
                } else {
                    args = LangUtil.split(runtimeProperties.getExecutionArgs());
                    valid = true;
                }
            }
            this.mainClass = mainClass;
            this.classpath = classpath;
            this.args = args;
            this.valid = valid;
        }

        private void showWarningMessage(String message) {
            JOptionPane.showMessageDialog(this.rootFrame, message, "Warning", 2);
        }
    }

    static class CompilerThread
    extends Thread {
        private final AjCompiler compiler;
        private final boolean buildFresh;

        public CompilerThread(AjCompiler compiler, boolean buildFresh) {
            this.compiler = compiler;
            this.buildFresh = buildFresh;
        }

        @Override
        public void run() {
            if (this.buildFresh) {
                this.compiler.buildFresh();
            } else {
                this.compiler.build();
            }
        }
    }
}

