/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.db;

import java.io.IOException;
import java.nio.ByteBuffer;

public class ChunkWriter {
    private double maxBytesPerMillisecond;
    private long lastWritePosition;
    private long bufferStartPosition;
    private byte[] buffer;
    private WriteCallback writeCallback;
    private long bytesWrittenSinceLastSleep;
    private long totalWriteTimeMs;
    private long totalBytesWritten;
    private SleepCallback sleepFunction = Thread::sleep;

    public ChunkWriter(int bufferSize, double maxBytesPerMillisecond, WriteCallback callback) {
        this.buffer = new byte[bufferSize];
        this.lastWritePosition = 0L;
        this.bufferStartPosition = 0L;
        this.maxBytesPerMillisecond = maxBytesPerMillisecond;
        this.writeCallback = callback;
    }

    public boolean write(long position, byte[] data) throws IOException {
        int bufferPosition;
        if (position == this.lastWritePosition && (bufferPosition = (int)(this.lastWritePosition - this.bufferStartPosition)) + data.length <= this.buffer.length) {
            System.arraycopy(data, 0, this.buffer, bufferPosition, data.length);
            this.lastWritePosition = position + (long)data.length;
            return false;
        }
        boolean wasInterrupted = this.flush();
        System.arraycopy(data, 0, this.buffer, 0, data.length);
        this.bufferStartPosition = position;
        this.lastWritePosition = position + (long)data.length;
        return wasInterrupted;
    }

    public boolean flush() throws IOException {
        int bytesToWrite = (int)(this.lastWritePosition - this.bufferStartPosition);
        if (bytesToWrite == 0) {
            return false;
        }
        long startTimeMs = System.currentTimeMillis();
        boolean result = this.writeCallback.write(ByteBuffer.wrap(this.buffer, 0, bytesToWrite), this.bufferStartPosition);
        long elapsedTimeMs = System.currentTimeMillis() - startTimeMs;
        this.totalBytesWritten += (long)bytesToWrite;
        this.totalWriteTimeMs += elapsedTimeMs;
        this.bytesWrittenSinceLastSleep = Math.max(0L, this.bytesWrittenSinceLastSleep + (long)bytesToWrite - (long)((double)elapsedTimeMs * this.maxBytesPerMillisecond));
        long desiredSleepTime = (long)((double)this.bytesWrittenSinceLastSleep / this.maxBytesPerMillisecond);
        if (desiredSleepTime > 0L) {
            try {
                this.sleepFunction.sleep(desiredSleepTime);
                this.bytesWrittenSinceLastSleep = (long)((double)this.bytesWrittenSinceLastSleep - this.maxBytesPerMillisecond * (double)desiredSleepTime);
            }
            catch (InterruptedException interruptedException) {
                result = true;
            }
        }
        this.bufferStartPosition = this.lastWritePosition;
        return result;
    }

    public void setSleepFunction(SleepCallback callback) {
        this.sleepFunction = callback;
    }

    public long getBytesWritten() {
        return this.totalBytesWritten;
    }

    public long getTotalWriteTimeMs() {
        return this.totalWriteTimeMs;
    }

    @FunctionalInterface
    public static interface SleepCallback {
        public void sleep(long var1) throws InterruptedException;
    }

    @FunctionalInterface
    public static interface WriteCallback {
        public boolean write(ByteBuffer var1, long var2) throws IOException;
    }
}

