/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.field;

import org.aspectj.org.eclipse.jdt.internal.core.nd.ITypeFactory;
import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.NdNode;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldInt;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldOneToMany;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldPointer;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.IDestructableField;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.IField;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.IRefCountedField;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.StructDef;

public class FieldManyToOne<T extends NdNode>
implements IDestructableField,
IField,
IRefCountedField {
    public static final FieldPointer TARGET;
    public static final FieldInt BACKPOINTER_INDEX;
    private int offset;
    Class<T> targetType;
    final Class<? extends NdNode> localType;
    FieldOneToMany<?> backPointer;
    private static final StructDef<FieldManyToOne> type;
    public final boolean pointsToOwner;

    static {
        type = StructDef.createAbstract(FieldManyToOne.class);
        TARGET = type.addPointer();
        BACKPOINTER_INDEX = type.addInt();
        type.done();
    }

    private FieldManyToOne(Class<? extends NdNode> localType, FieldOneToMany<?> backPointer, boolean pointsToOwner) {
        this.localType = localType;
        this.pointsToOwner = pointsToOwner;
        if (backPointer != null) {
            if (backPointer.forwardPointer != null && backPointer.forwardPointer != this) {
                throw new IllegalArgumentException("Attempted to construct a FieldNodePointer referring to a backpointer list that is already in use by another field");
            }
            backPointer.targetType = localType;
            this.targetType = backPointer.localType;
            backPointer.forwardPointer = this;
        }
        this.backPointer = backPointer;
    }

    public static <T extends NdNode, B extends NdNode> FieldManyToOne<T> create(StructDef<B> builder, FieldOneToMany<B> forwardPointer) {
        FieldManyToOne<T> result = new FieldManyToOne<T>(builder.getStructClass(), forwardPointer, false);
        builder.add(result);
        builder.addDestructableField(result);
        return result;
    }

    public static <T extends NdNode, B extends NdNode> FieldManyToOne<T> createOwner(StructDef<B> builder, FieldOneToMany<B> forwardPointer) {
        FieldManyToOne<T> result = new FieldManyToOne<T>(builder.getStructClass(), forwardPointer, true);
        builder.add(result);
        builder.addDestructableField(result);
        builder.addOwnerField(result);
        return result;
    }

    public T get(Nd nd, long address) {
        return NdNode.load(nd, this.getAddress(nd, address), this.targetType);
    }

    public long getAddress(Nd nd, long address) {
        return nd.getDB().getRecPtr(address + (long)this.offset);
    }

    public void put(Nd nd, long address, T value) {
        if (value != null) {
            this.put(nd, address, ((NdNode)value).address);
        } else {
            this.put(nd, address, 0L);
        }
    }

    public void put(Nd nd, long address, long newTargetAddress) {
        long fieldStart = address + (long)this.offset;
        if (this.backPointer == null) {
            throw new IllegalStateException("FieldNodePointer must be associated with a FieldBackPointer");
        }
        long oldTargetAddress = TARGET.get(nd, fieldStart);
        if (oldTargetAddress == newTargetAddress) {
            return;
        }
        this.detachFromOldTarget(nd, address, oldTargetAddress);
        TARGET.put(nd, fieldStart, newTargetAddress);
        if (newTargetAddress != 0L) {
            BACKPOINTER_INDEX.put(nd, fieldStart, this.backPointer.add(nd, newTargetAddress, address));
        } else if (this.pointsToOwner) {
            nd.scheduleDeletion(address);
        }
    }

    protected void detachFromOldTarget(Nd nd, long address, long oldTargetAddress) {
        long fieldStart = address + (long)this.offset;
        if (oldTargetAddress != 0L) {
            int oldIndex = BACKPOINTER_INDEX.get(nd, fieldStart);
            this.backPointer.remove(nd, oldTargetAddress, oldIndex);
            short targetTypeId = NdNode.NODE_TYPE.get(nd, oldTargetAddress);
            ITypeFactory typeFactory = nd.getTypeFactory(targetTypeId);
            if (typeFactory.getDeletionSemantics() == StructDef.DeletionSemantics.REFCOUNTED && typeFactory.isReadyForDeletion(nd, oldTargetAddress)) {
                nd.scheduleDeletion(oldTargetAddress);
            }
        }
    }

    void adjustIndex(Nd nd, long address, int index) {
        BACKPOINTER_INDEX.put(nd, address + (long)this.offset, index);
    }

    @Override
    public void destruct(Nd nd, long address) {
        long fieldStart = address + (long)this.offset;
        long oldTargetAddress = TARGET.get(nd, fieldStart);
        this.detachFromOldTarget(nd, address, oldTargetAddress);
        TARGET.put(nd, fieldStart, 0L);
    }

    void clearedByBackPointer(Nd nd, long address) {
        long fieldStart = (long)this.offset + address;
        TARGET.put(nd, fieldStart, 0L);
        BACKPOINTER_INDEX.put(nd, fieldStart, 0);
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getRecordSize() {
        return type.size();
    }

    @Override
    public boolean hasReferences(Nd nd, long address) {
        long fieldStart = (long)this.offset + address;
        long target = TARGET.get(nd, fieldStart);
        return target != 0L;
    }
}

