/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.org.eclipse.jdt.core.dom.AST;
import org.aspectj.org.eclipse.jdt.core.dom.ASTMatcher;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.core.dom.ASTVisitor;
import org.aspectj.org.eclipse.jdt.core.dom.AjASTMatcher;
import org.aspectj.org.eclipse.jdt.core.dom.AjASTVisitor;
import org.aspectj.org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.aspectj.org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.aspectj.org.eclipse.jdt.core.dom.DeclareDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.DeclareErrorDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.Javadoc;
import org.aspectj.org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.aspectj.org.eclipse.jdt.core.dom.TypePattern;

public class DeclareParentsDeclaration
extends DeclareDeclaration {
    public static final ChildPropertyDescriptor JAVADOC_PROPERTY = DeclareParentsDeclaration.internalJavadocPropertyFactory(DeclareParentsDeclaration.class);
    public static final ChildPropertyDescriptor CHILD_TYPE_PATTERN_PROPERTY = new ChildPropertyDescriptor(DeclareParentsDeclaration.class, "childTypePattern", TypePattern.class, true, false);
    public static final SimplePropertyDescriptor IS_EXTENDS_PROPERTY = new SimplePropertyDescriptor(DeclareParentsDeclaration.class, "isExtends", Boolean.TYPE, true);
    public static final ChildListPropertyDescriptor PARENTS_TYPE_PATTERNS_LIST_PROPERTY = new ChildListPropertyDescriptor(DeclareParentsDeclaration.class, "typePatternsList", TypePattern.class, false);
    private static final List PROPERTY_DESCRIPTORS_2_0;
    private static final List PROPERTY_DESCRIPTORS_3_0;
    private boolean isExtends;
    private TypePattern childTypePattern;
    protected ASTNode.NodeList parentTypePatterns = new ASTNode.NodeList(this, PARENTS_TYPE_PATTERNS_LIST_PROPERTY);

    DeclareParentsDeclaration(AST ast) {
        this(ast, false);
    }

    DeclareParentsDeclaration(AST ast, boolean isExtends) {
        super(ast);
        this.isExtends = isExtends;
    }

    @Override
    ASTNode clone0(AST target) {
        DeclareParentsDeclaration result = new DeclareParentsDeclaration(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setJavadoc((Javadoc)ASTNode.copySubtree(target, this.getJavadoc()));
        result.setChildTypePattern((TypePattern)ASTNode.copySubtree(target, this.getChildTypePattern()));
        result.setExtends(this.isExtends());
        result.parentTypePatterns().addAll(ASTNode.copySubtrees(target, this.parentTypePatterns()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return ((AjASTMatcher)matcher).match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        if (visitor instanceof AjASTVisitor) {
            boolean visitChildren = ((AjASTVisitor)visitor).visit(this);
            if (visitChildren) {
                this.acceptChild(visitor, this.getJavadoc());
                this.acceptChild(visitor, this.getChildTypePattern());
                this.acceptChildren(visitor, this.parentTypePatterns);
            }
            ((AjASTVisitor)visitor).endVisit(this);
        }
    }

    @Override
    SimplePropertyDescriptor internalModifiersProperty() {
        return DeclareParentsDeclaration.internalModifiersPropertyFactory(DeclareErrorDeclaration.class);
    }

    @Override
    ChildListPropertyDescriptor internalModifiers2Property() {
        return DeclareParentsDeclaration.internalModifiers2PropertyFactory(DeclareErrorDeclaration.class);
    }

    @Override
    ChildPropertyDescriptor internalJavadocProperty() {
        return JAVADOC_PROPERTY;
    }

    public static List propertyDescriptors(int apiLevel) {
        if (apiLevel == 2) {
            return PROPERTY_DESCRIPTORS_2_0;
        }
        return PROPERTY_DESCRIPTORS_3_0;
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return DeclareParentsDeclaration.propertyDescriptors(apiLevel);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == JAVADOC_PROPERTY) {
            if (get) {
                return this.getJavadoc();
            }
            this.setJavadoc((Javadoc)child);
            return null;
        }
        if (property == CHILD_TYPE_PATTERN_PROPERTY) {
            if (get) {
                return this.getChildTypePattern();
            }
            this.setChildTypePattern((TypePattern)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == IS_EXTENDS_PROPERTY) {
            if (get) {
                return this.isExtends();
            }
            this.setExtends(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == PARENTS_TYPE_PATTERNS_LIST_PROPERTY) {
            return this.parentTypePatterns();
        }
        return super.internalGetChildListProperty(property);
    }

    public List parentTypePatterns() {
        return this.parentTypePatterns;
    }

    public TypePattern getChildTypePattern() {
        return this.childTypePattern;
    }

    public void setChildTypePattern(TypePattern typePattern) {
        if (typePattern == null) {
            throw new IllegalArgumentException();
        }
        TypePattern oldChild = this.childTypePattern;
        this.preReplaceChild(oldChild, typePattern, CHILD_TYPE_PATTERN_PROPERTY);
        this.childTypePattern = typePattern;
        this.postReplaceChild(oldChild, typePattern, CHILD_TYPE_PATTERN_PROPERTY);
    }

    public boolean isExtends() {
        return this.isExtends;
    }

    public void setExtends(boolean isExtends) {
        this.preValueChange(IS_EXTENDS_PROPERTY);
        this.isExtends = isExtends;
        this.postValueChange(IS_EXTENDS_PROPERTY);
    }

    static {
        ArrayList propertyList = new ArrayList(4);
        DeclareParentsDeclaration.createPropertyList(DeclareParentsDeclaration.class, propertyList);
        DeclareParentsDeclaration.addProperty(JAVADOC_PROPERTY, propertyList);
        DeclareParentsDeclaration.addProperty(CHILD_TYPE_PATTERN_PROPERTY, propertyList);
        DeclareParentsDeclaration.addProperty(IS_EXTENDS_PROPERTY, propertyList);
        DeclareParentsDeclaration.addProperty(PARENTS_TYPE_PATTERNS_LIST_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_2_0 = DeclareParentsDeclaration.reapPropertyList(propertyList);
        propertyList = new ArrayList(4);
        DeclareParentsDeclaration.createPropertyList(DeclareParentsDeclaration.class, propertyList);
        DeclareParentsDeclaration.addProperty(JAVADOC_PROPERTY, propertyList);
        DeclareParentsDeclaration.addProperty(CHILD_TYPE_PATTERN_PROPERTY, propertyList);
        DeclareParentsDeclaration.addProperty(IS_EXTENDS_PROPERTY, propertyList);
        DeclareParentsDeclaration.addProperty(PARENTS_TYPE_PATTERNS_LIST_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_3_0 = DeclareParentsDeclaration.reapPropertyList(propertyList);
    }
}

