/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.Node;

public final class LineNumber
implements Node {
    private int startPC;
    private int lineNumber;

    public LineNumber(LineNumber lineNumber) {
        this(lineNumber.getStartPC(), lineNumber.getLineNumber());
    }

    LineNumber(DataInputStream dataInputStream) throws IOException {
        this(dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
    }

    public LineNumber(int n, int n2) {
        this.startPC = n;
        this.lineNumber = n2;
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitLineNumber(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.startPC);
        dataOutputStream.writeShort(this.lineNumber);
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final int getStartPC() {
        return this.startPC;
    }

    public final String toString() {
        return "LineNumber(" + this.startPC + ", " + this.lineNumber + ")";
    }

    public LineNumber copy() {
        return new LineNumber(this);
    }
}

