/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationDecorator;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.ManifestAnalyzer;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;

public class ClasspathJar
extends ClasspathLocation {
    private static int maxOpenArchives = 1000;
    private static final int MAXOPEN_DEFAULT = 1000;
    private static List openArchives = new ArrayList();
    protected File file;
    protected ZipFile zipFile;
    protected ZipFile annotationZipFile;
    protected boolean closeZipFileAtEnd;
    protected Hashtable packageCache;
    protected List<String> annotationPaths;

    static {
        String openarchivesString = ClasspathJar.getSystemPropertyWithoutSecurityException("org.aspectj.weaver.openarchives", Integer.toString(1000));
        maxOpenArchives = Integer.parseInt(openarchivesString);
        if (maxOpenArchives < 20) {
            maxOpenArchives = 1000;
        }
    }

    public ClasspathJar(File file, boolean closeZipFileAtEnd, AccessRuleSet accessRuleSet, String destinationPath) {
        super(accessRuleSet, destinationPath);
        this.file = file;
        this.closeZipFileAtEnd = closeZipFileAtEnd;
    }

    /*
     * Loose catch block
     */
    @Override
    public List fetchLinkedJars(FileSystem.ClasspathSectionProblemReporter problemReporter) {
        ArrayList<ClasspathJar> arrayList;
        InputStream inputStream;
        block19: {
            inputStream = null;
            this.initialize();
            ArrayList<ClasspathJar> result = new ArrayList<ClasspathJar>();
            ZipEntry manifest = this.zipFile.getEntry("META-INF/MANIFEST.MF");
            if (manifest != null) {
                inputStream = this.zipFile.getInputStream(manifest);
                ManifestAnalyzer analyzer = new ManifestAnalyzer();
                boolean success = analyzer.analyzeManifestContents(inputStream);
                List calledFileNames = analyzer.getCalledFileNames();
                if (problemReporter != null) {
                    if (!success || analyzer.getClasspathSectionsCount() == 1 && calledFileNames == null) {
                        problemReporter.invalidClasspathSection(this.getPath());
                    } else if (analyzer.getClasspathSectionsCount() > 1) {
                        problemReporter.multipleClasspathSections(this.getPath());
                    }
                }
                if (calledFileNames != null) {
                    Iterator calledFilesIterator = calledFileNames.iterator();
                    String directoryPath = this.getPath();
                    int lastSeparator = directoryPath.lastIndexOf(File.separatorChar);
                    directoryPath = directoryPath.substring(0, lastSeparator + 1);
                    while (calledFilesIterator.hasNext()) {
                        result.add(new ClasspathJar(new File(String.valueOf(directoryPath) + (String)calledFilesIterator.next()), this.closeZipFileAtEnd, this.accessRuleSet, this.destinationPath));
                    }
                }
            }
            arrayList = result;
            if (inputStream == null) break block19;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList;
        catch (IOException e) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        return this.findClass(typeName, qualifiedPackageName, qualifiedBinaryFileName, false);
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String qualifiedBinaryFileName, boolean asBinaryOnly) {
        if (!this.isPackage(qualifiedPackageName)) {
            return null;
        }
        try {
            this.ensureOpen();
            IBinaryType reader = ClassFileReader.read(this.zipFile, qualifiedBinaryFileName);
            if (reader != null) {
                if (this.annotationPaths != null) {
                    String qualifiedClassName = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - "CLASS".length() - 1);
                    for (String annotationPath : this.annotationPaths) {
                        try {
                            if (this.annotationZipFile == null) {
                                this.annotationZipFile = ExternalAnnotationDecorator.getAnnotationZipFile(annotationPath, null);
                            }
                            if ((reader = ExternalAnnotationDecorator.create(reader, annotationPath, qualifiedClassName, this.annotationZipFile)).getExternalAnnotationStatus() != BinaryTypeBinding.ExternalAnnotationStatus.TYPE_IS_ANNOTATED) continue;
                            break;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                return new NameEnvironmentAnswer(reader, this.fetchAccessRestriction(qualifiedBinaryFileName));
            }
        }
        catch (ClassFormatException classFormatException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean hasAnnotationFileFor(String qualifiedTypeName) {
        return this.zipFile.getEntry(String.valueOf(qualifiedTypeName) + ".eea") != null;
    }

    @Override
    public char[][][] findTypeNames(String qualifiedPackageName) {
        if (!this.isPackage(qualifiedPackageName)) {
            return null;
        }
        try {
            this.ensureOpen();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        ArrayList<char[][]> answers = new ArrayList<char[][]>();
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        block2: while (e.hasMoreElements()) {
            String fileName = e.nextElement().getName();
            int last = fileName.lastIndexOf(47);
            while (last > 0) {
                String packageName = fileName.substring(0, last);
                if (!qualifiedPackageName.equals(packageName)) continue block2;
                int indexOfDot = fileName.lastIndexOf(46);
                if (indexOfDot == -1) continue;
                String typeName = fileName.substring(last + 1, indexOfDot);
                char[] packageArray = packageName.toCharArray();
                answers.add(CharOperation.arrayConcat(CharOperation.splitOn('/', packageArray), typeName.toCharArray()));
            }
        }
        int size = answers.size();
        if (size != 0) {
            char[][][] result = new char[size][][];
            answers.toArray((T[])result);
            return null;
        }
        return null;
    }

    @Override
    public void initialize() throws IOException {
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(this.file);
        }
    }

    @Override
    public boolean isPackage(String qualifiedPackageName) {
        if (this.packageCache != null) {
            return this.packageCache.containsKey(qualifiedPackageName);
        }
        this.packageCache = new Hashtable(41);
        this.packageCache.put(Util.EMPTY_STRING, Util.EMPTY_STRING);
        try {
            this.ensureOpen();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        block2: while (e.hasMoreElements()) {
            String fileName = e.nextElement().getName();
            int last = fileName.lastIndexOf(47);
            while (last > 0) {
                String packageName = fileName.substring(0, last);
                if (this.packageCache.containsKey(packageName)) continue block2;
                this.packageCache.put(packageName, packageName);
                last = packageName.lastIndexOf(47);
            }
        }
        return this.packageCache.containsKey(qualifiedPackageName);
    }

    @Override
    public void reset() {
        if (this.closeZipFileAtEnd) {
            if (this.zipFile != null) {
                this.close();
            }
            if (this.annotationZipFile != null) {
                try {
                    this.annotationZipFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.annotationZipFile = null;
            }
        }
        this.packageCache = null;
    }

    public String toString() {
        return "Classpath for jar file " + this.file.getPath();
    }

    @Override
    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            String path2 = this.getPath();
            char[] rawName = path2.toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace(rawName, '\\', '/');
            }
            this.normalizedPath = CharOperation.subarray(rawName, 0, CharOperation.lastIndexOf('.', rawName));
        }
        return this.normalizedPath;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            try {
                this.path = this.file.getCanonicalPath();
            }
            catch (IOException e) {
                this.path = this.file.getAbsolutePath();
            }
        }
        return this.path;
    }

    @Override
    public int getMode() {
        return 2;
    }

    private void ensureOpen() throws IOException {
        if (this.zipFile != null) {
            return;
        }
        if (openArchives.size() >= maxOpenArchives) {
            this.closeSomeArchives(openArchives.size() / 10);
        }
        this.zipFile = new ZipFile(this.file);
        openArchives.add(this);
    }

    private void closeSomeArchives(int n) {
        int i = n - 1;
        while (i >= 0) {
            ClasspathJar zf = (ClasspathJar)openArchives.get(0);
            zf.close();
            --i;
        }
    }

    public void close() {
        if (this.zipFile == null) {
            return;
        }
        try {
            try {
                openArchives.remove(this);
                this.zipFile.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                this.zipFile = null;
            }
        }
        finally {
            this.zipFile = null;
        }
    }

    private static String getSystemPropertyWithoutSecurityException(String aPropertyName, String aDefaultValue) {
        try {
            return System.getProperty(aPropertyName, aDefaultValue);
        }
        catch (SecurityException ex) {
            return aDefaultValue;
        }
    }
}

