/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.IconRegistry;
import org.aspectj.ajde.ui.swing.OptionsPanel;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.Version;

public class OptionsFrame
extends JFrame {
    private static final long serialVersionUID = -859222442871124487L;
    private static final String ABOUT_TEXT = "\nThe AspectJ compiler and core tools are produced by the\nAspectJ project.\n\nThis software is distributed under the Eclipse Public License\nversion 1.0, approved by the Open Source Initiative as\nconforming to the Open Source Definition.\n\nFor support or for more information about the AspectJ\nproject or the license, visit the project home page at\n    http://eclipse.org/aspectj\n\nIf you find a bug (not solved by the documentation in the\nDevelopment Environment Guide available with this release,\nany release notes, or the bug database), please submit steps\nto reproduce the bug (using the IDE component) at:\n    http://bugs.eclipse.org/bugs/enter_bug.cgi?product=AspectJ";
    private JTabbedPane main_tabbedPane = new JTabbedPane();
    private JPanel button_panel = new JPanel();
    private JButton apply_button = new JButton();
    private JButton cancel_button = new JButton();
    private JButton ok_button = new JButton();
    private TitledBorder titledBorder1;
    private TitledBorder titledBorder2;
    private TitledBorder titledBorder3;
    private TitledBorder titledBorder4;
    private TitledBorder titledBorder5;
    private TitledBorder titledBorder6;
    private TitledBorder titledBorder7;
    private Border border4;
    private TitledBorder titledBorder8;
    private Border border5;
    private TitledBorder titledBorder9;
    private TitledBorder titledBorder10;
    private Border border7;
    private TitledBorder titledBorder11;
    private Border border8;
    private TitledBorder titledBorder12;
    private JPanel about_panel = new JPanel();
    private BorderLayout borderLayout9 = new BorderLayout();
    JTextArea jTextArea1 = new JTextArea();
    JPanel jPanel1 = new JPanel();
    JLabel version_label = new JLabel();
    JLabel jLabel1 = new JLabel();
    BorderLayout borderLayout1 = new BorderLayout();
    Border border9;
    JLabel built_label = new JLabel();

    public OptionsFrame(IconRegistry icons) {
        try {
            this.jbInit();
            this.setTitle("AJDE Settings");
            this.setIconImage(((ImageIcon)icons.getBrowserOptionsIcon()).getImage());
            this.setSize(500, 500);
            this.setLocation(200, 100);
            this.version_label.setText("Version: 1.8.1");
            this.built_label.setText("Built: " + new Date(Version.getTime()).toString());
        }
        catch (Exception e) {
            Message msg = new Message("Could not open OptionsFrame.", IMessage.ERROR, e, null);
            Ajde.getDefault().getMessageHandler().handleMessage(msg);
        }
    }

    public void addOptionsPanel(OptionsPanel panel) {
        this.main_tabbedPane.add((Component)panel, this.main_tabbedPane.getComponentCount() - 1);
        try {
            panel.loadOptions();
        }
        catch (IOException e) {
            Message msg = new Message("Could not load options.", IMessage.ERROR, e, null);
            Ajde.getDefault().getMessageHandler().handleMessage(msg);
        }
    }

    public void removeOptionsPanel(OptionsPanel panel) {
        this.main_tabbedPane.remove(panel);
    }

    public void showPanel(OptionsPanel panel) {
        this.setVisible(true);
        this.main_tabbedPane.setSelectedComponent(panel);
    }

    private void saveOptions() {
        try {
            Component[] components = this.main_tabbedPane.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof OptionsPanel)) continue;
                ((OptionsPanel)components[i]).saveOptions();
            }
        }
        catch (IOException ioe) {
            Message msg = new Message("Could not load options.", IMessage.ERROR, ioe, null);
            Ajde.getDefault().getMessageHandler().handleMessage(msg);
        }
    }

    private void close() {
        this.setVisible(false);
    }

    private void apply_button_actionPerformed(ActionEvent e) {
        this.saveOptions();
    }

    private void ok_button_actionPerformed(ActionEvent e) {
        this.saveOptions();
        this.close();
    }

    private void cancel_button_actionPerformed(ActionEvent e) {
        this.close();
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), "Sorting");
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "Associations (navigeable relations between sturcture nodes)");
        this.titledBorder3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), "Member Filtering (nodes to exclude from view)");
        BorderFactory.createLineBorder(Color.black, 2);
        this.titledBorder4 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "Compile Options");
        this.titledBorder5 = new TitledBorder("");
        BorderFactory.createLineBorder(Color.black, 2);
        this.titledBorder6 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "Run Options");
        BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158));
        this.titledBorder7 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), "Granularity (all nodes below selected level will be hidden)");
        this.border4 = BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158));
        this.titledBorder8 = new TitledBorder(this.border4, "Member Visibility");
        this.border5 = BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158));
        this.titledBorder9 = new TitledBorder(this.border5, "Member Modifiers");
        BorderFactory.createEmptyBorder();
        this.titledBorder10 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "Structure View Properties");
        this.border7 = BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158));
        this.titledBorder11 = new TitledBorder(this.border7, "Member Kinds");
        this.border8 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.titledBorder12 = new TitledBorder(this.border8, "Build Paths");
        this.border9 = BorderFactory.createEmptyBorder(6, 6, 6, 6);
        this.jPanel1.setLayout(this.borderLayout1);
        this.jLabel1.setFont(new Font("Dialog", 1, 14));
        this.jLabel1.setText("AspectJ Development Environment (AJDE)");
        this.version_label.setFont(new Font("Dialog", 1, 12));
        this.version_label.setText("Version: ");
        this.apply_button.setFont(new Font("Dialog", 0, 11));
        this.apply_button.setMaximumSize(new Dimension(70, 24));
        this.apply_button.setMinimumSize(new Dimension(63, 24));
        this.apply_button.setPreferredSize(new Dimension(70, 24));
        this.apply_button.setText("Apply");
        this.apply_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsFrame.this.apply_button_actionPerformed(e);
            }
        });
        this.cancel_button.setFont(new Font("Dialog", 0, 11));
        this.cancel_button.setMaximumSize(new Dimension(70, 24));
        this.cancel_button.setMinimumSize(new Dimension(67, 24));
        this.cancel_button.setPreferredSize(new Dimension(70, 24));
        this.cancel_button.setText("Cancel");
        this.cancel_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsFrame.this.cancel_button_actionPerformed(e);
            }
        });
        this.ok_button.setFont(new Font("Dialog", 0, 11));
        this.ok_button.setMaximumSize(new Dimension(70, 24));
        this.ok_button.setMinimumSize(new Dimension(49, 24));
        this.ok_button.setPreferredSize(new Dimension(70, 24));
        this.ok_button.setText("OK");
        this.ok_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsFrame.this.ok_button_actionPerformed(e);
            }
        });
        this.main_tabbedPane.setFont(new Font("Dialog", 0, 11));
        this.titledBorder1.setTitle("Ordering (sort order of nodes)");
        this.titledBorder1.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder2.setTitle("Associations (navigeable relations between structure nodes)");
        this.titledBorder2.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder3.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder6.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder5.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder4.setTitle("AjCompiler Flags");
        this.titledBorder4.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder7.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder8.setTitle("Access Modifiers");
        this.titledBorder8.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder9.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder10.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder11.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder12.setTitleFont(new Font("Dialog", 0, 11));
        this.about_panel.setLayout(this.borderLayout9);
        this.jTextArea1.setBackground(UIManager.getColor("ColorChooser.background"));
        this.jTextArea1.setFont(new Font("SansSerif", 0, 12));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setText(ABOUT_TEXT);
        this.about_panel.setBorder(this.border9);
        this.built_label.setText("Built: ");
        this.built_label.setFont(new Font("Dialog", 1, 12));
        this.main_tabbedPane.add((Component)this.about_panel, "About AJDE");
        this.getContentPane().add((Component)this.button_panel, "South");
        this.button_panel.add((Component)this.ok_button, null);
        this.button_panel.add((Component)this.cancel_button, null);
        this.button_panel.add((Component)this.apply_button, null);
        this.getContentPane().add((Component)this.main_tabbedPane, "Center");
        this.about_panel.add((Component)this.jTextArea1, "Center");
        this.about_panel.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.jLabel1, "North");
        this.jPanel1.add((Component)this.version_label, "Center");
        this.jPanel1.add((Component)this.built_label, "South");
    }
}

