/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.ajdt.internal.compiler.ast.AccessForInlineVisitor;
import org.aspectj.ajdt.internal.compiler.ast.AspectClinit;
import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.ajdt.internal.compiler.ast.AtAspectJAnnotationFactory;
import org.aspectj.ajdt.internal.compiler.ast.DeclareDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.EclipseAttributeAdapter;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.IntertypeMemberClassDeclaration;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseScope;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseSourceType;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseTypeMunger;
import org.aspectj.ajdt.internal.compiler.lookup.HelperInterfaceBinding;
import org.aspectj.ajdt.internal.compiler.lookup.InlineAccessFieldBinding;
import org.aspectj.ajdt.internal.compiler.lookup.IntertypeMemberTypeFinder;
import org.aspectj.ajdt.internal.compiler.lookup.PrivilegedHandler;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.NameMangler;
import org.aspectj.weaver.NewMemberClassTypeMunger;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.PerFromSuper;
import org.aspectj.weaver.patterns.PerSingleton;
import org.aspectj.weaver.patterns.TypePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectDeclaration
extends TypeDeclaration {
    public PerClause perClause;
    public ResolvedMember aspectOfMethod;
    public ResolvedMember ptwGetWithinTypeNameMethod;
    public ResolvedMember hasAspectMethod;
    public Map<ResolvedMember, Binding> accessForInline = new HashMap<ResolvedMember, Binding>();
    public Map<ResolvedMember, AccessForInlineVisitor.SuperAccessMethodPair> superAccessForInline = new HashMap<ResolvedMember, AccessForInlineVisitor.SuperAccessMethodPair>();
    public boolean isPrivileged;
    public EclipseSourceType concreteName;
    public ReferenceType typeX;
    public EclipseFactory factory;
    public int adviceCounter = 1;
    public int declareCounter = 1;
    public TypePattern dominatesPattern;
    private int declaredModifiers;
    private FieldBinding initFailureField = null;
    private static char[] weaverVersionChars = "org.aspectj.weaver.WeaverVersion".toCharArray();

    public AspectDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    @Override
    public void resolve() {
        this.declaredModifiers = this.modifiers;
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
        super.resolve();
    }

    public void checkSpec(ClassScope scope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        if (this.dominatesPattern != null) {
            scope.problemReporter().signalError(this.dominatesPattern.getStart(), this.dominatesPattern.getEnd(), "dominates has changed for 1.1, use 'declare precedence: " + new String(this.name) + ", " + this.dominatesPattern.toString() + ";' " + "in the body of the aspect instead");
        }
        if (!this.isAbstract()) {
            for (MethodBinding m : this.binding.methods()) {
                if (!m.isConstructor()) continue;
                methods[i] = new MethodBinding(m, this.binding){

                    public boolean canBeSeenBy(InvocationSite invocationSite, Scope scope) {
                        return false;
                    }
                };
                if (m.parameters == null || m.parameters.length == 0) continue;
                scope.problemReporter().signalError(m.sourceStart(), m.sourceEnd(), "only zero-argument constructors allowed in concrete aspect");
            }
            if (this.typeParameters != null && this.typeParameters.length > 0) {
                scope.problemReporter().signalError(this.sourceStart(), this.sourceEnd(), "only abstract aspects can have type parameters");
            }
        }
        if (this.enclosingType != null && !Modifier.isStatic(this.modifiers)) {
            scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "inner aspects must be static");
            this.ignoreFurtherInvestigation = true;
            return;
        }
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(scope);
        ReferenceType myType = this.typeX;
        ResolvedType superType = ((ResolvedType)myType).getSuperclass();
        if (!world.isXSerializableAspects()) {
            if (world.getWorld().getCoreType(UnresolvedType.SERIALIZABLE).isAssignableFrom(myType)) {
                scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "aspects may not implement Serializable");
                this.ignoreFurtherInvestigation = true;
                return;
            }
            if (world.getWorld().getCoreType(UnresolvedType.CLONEABLE).isAssignableFrom(myType)) {
                scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "aspects may not implement Cloneable");
                this.ignoreFurtherInvestigation = true;
                return;
            }
        }
        if (superType.isAspect()) {
            if (!superType.isAbstract()) {
                scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "can not extend a concrete aspect");
                this.ignoreFurtherInvestigation = true;
                return;
            }
            if (superType.isRawType()) {
                scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "a generic super-aspect must be fully parameterized in an extends clause");
                this.ignoreFurtherInvestigation = true;
                return;
            }
        }
    }

    public void addAtAspectJAnnotations() {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        Annotation atAspectAnnotation = AtAspectJAnnotationFactory.createAspectAnnotation(this.perClause.toDeclarationString(), this.declarationSourceStart);
        Annotation privilegedAnnotation = null;
        if (this.isPrivileged) {
            privilegedAnnotation = AtAspectJAnnotationFactory.createPrivilegedAnnotation(this.declarationSourceStart);
        }
        Annotation[] toAdd = new Annotation[this.isPrivileged ? 2 : 1];
        toAdd[0] = atAspectAnnotation;
        if (this.isPrivileged) {
            toAdd[1] = privilegedAnnotation;
        }
        if (this.annotations == null) {
            this.annotations = toAdd;
        } else {
            Annotation[] old = this.annotations;
            this.annotations = new Annotation[this.annotations.length + toAdd.length];
            System.arraycopy(old, 0, this.annotations, 0, old.length);
            System.arraycopy(toAdd, 0, this.annotations, old.length, toAdd.length);
        }
    }

    @Override
    public void generateCode(ClassFile enclosingClassFile) {
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            ClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
            return;
        }
        this.modifiers = AstUtil.makePublic(this.modifiers);
        this.binding.modifiers = AstUtil.makePublic(this.binding.modifiers);
        if (!this.isAbstract()) {
            if (this.perClause != null && this.perClause.getKind() == PerClause.SINGLETON) {
                this.initFailureField = this.factory.createSyntheticFieldBinding(this.binding, AjcMemberMaker.initFailureCauseField(this.typeX));
            }
            if (this.perClause != null) {
                if (this.perClause.getKind() == PerClause.SINGLETON) {
                    this.factory.createSyntheticFieldBinding(this.binding, AjcMemberMaker.perSingletonField(this.typeX));
                    this.methods[0] = new AspectClinit((Clinit)this.methods[0], this.compilationResult, false, true, this.initFailureField);
                } else if (this.perClause.getKind() == PerClause.PERCFLOW) {
                    this.factory.createSyntheticFieldBinding(this.binding, AjcMemberMaker.perCflowField(this.typeX));
                    this.methods[0] = new AspectClinit((Clinit)this.methods[0], this.compilationResult, true, false, null);
                } else if (this.perClause.getKind() != PerClause.PEROBJECT) {
                    if (this.perClause.getKind() == PerClause.PERTYPEWITHIN) {
                        this.factory.createSyntheticFieldBinding(this.binding, AjcMemberMaker.perTypeWithinWithinTypeField(this.typeX, this.typeX));
                    } else {
                        throw new RuntimeException("unimplemented");
                    }
                }
            }
        }
        if (EclipseFactory.DEBUG) {
            System.out.println(this.toString());
        }
        super.generateCode(enclosingClassFile);
    }

    @Override
    public boolean needClassInitMethod() {
        return true;
    }

    @Override
    protected void generateAttributes(ClassFile classFile) {
        PrivilegedHandler privilegedHandler;
        ResolvedMember[] members;
        if (!this.isAbstract()) {
            this.generatePerSupportMembers(classFile);
        }
        this.generateInlineAccessMembers(classFile);
        this.addVersionAttributeIfNecessary(classFile);
        classFile.extraAttributes.add(new EclipseAttributeAdapter(new AjAttribute.Aspect(this.perClause)));
        if (this.binding.privilegedHandler != null && (members = (privilegedHandler = (PrivilegedHandler)this.binding.privilegedHandler).getMembers()).length > 0) {
            classFile.extraAttributes.add(new EclipseAttributeAdapter(new AjAttribute.PrivilegedAttribute(members)));
        }
        if (this.memberTypes != null) {
            for (int i = 0; i < this.memberTypes.length; ++i) {
                IntertypeMemberClassDeclaration itdMemberClassDeclaration;
                AjAttribute attribute;
                if (!(this.memberTypes[i] instanceof IntertypeMemberClassDeclaration) || (attribute = (itdMemberClassDeclaration = (IntertypeMemberClassDeclaration)this.memberTypes[i]).getAttribute()) == null) continue;
                classFile.extraAttributes.add(new EclipseAttributeAdapter(attribute));
            }
        }
        classFile.extraAttributes.add(new EclipseAttributeAdapter(new AjAttribute.SourceContextAttribute(new String(this.compilationResult().getFileName()), this.compilationResult().lineSeparatorPositions)));
        super.generateAttributes(classFile);
    }

    private void addVersionAttributeIfNecessary(ClassFile classFile) {
        for (EclipseAttributeAdapter element : classFile.extraAttributes) {
            if (!CharOperation.equals(element.getNameChars(), weaverVersionChars)) continue;
            return;
        }
        classFile.extraAttributes.add(new EclipseAttributeAdapter(new AjAttribute.WeaverVersionInfo()));
    }

    private void generateInlineAccessMembers(ClassFile classFile) {
        for (AccessForInlineVisitor.SuperAccessMethodPair superAccessMethodPair : this.superAccessForInline.values()) {
            this.generateSuperAccessMethod(classFile, superAccessMethodPair.accessMethod, superAccessMethodPair.originalMethod);
        }
        for (Map.Entry entry : this.accessForInline.entrySet()) {
            this.generateInlineAccessMethod(classFile, (Binding)entry.getValue(), (ResolvedMember)entry.getKey());
        }
    }

    private void generatePerSupportMembers(ClassFile classFile) {
        if (this.isAbstract()) {
            return;
        }
        if (this.aspectOfMethod == null) {
            return;
        }
        if (this.perClause == null) {
            System.err.println("has null perClause: " + this);
            return;
        }
        if (this.perClause.getKind() == PerClause.SINGLETON) {
            this.generatePerSingletonAspectOfMethod(classFile);
            this.generatePerSingletonHasAspectMethod(classFile);
            this.generatePerSingletonAjcClinitMethod(classFile);
        } else if (this.perClause.getKind() == PerClause.PERCFLOW) {
            this.generatePerCflowAspectOfMethod(classFile);
            this.generatePerCflowHasAspectMethod(classFile);
            this.generatePerCflowPushMethod(classFile);
            this.generatePerCflowAjcClinitMethod(classFile);
        } else if (this.perClause.getKind() == PerClause.PEROBJECT) {
            TypeBinding interfaceType = this.generatePerObjectInterface(classFile);
            this.generatePerObjectAspectOfMethod(classFile, interfaceType);
            this.generatePerObjectHasAspectMethod(classFile, interfaceType);
            this.generatePerObjectBindMethod(classFile, interfaceType);
        } else if (this.perClause.getKind() == PerClause.PERTYPEWITHIN) {
            this.generatePerTypeWithinAspectOfMethod(classFile);
            this.generatePerTypeWithinGetInstanceMethod(classFile);
            this.generatePerTypeWithinHasAspectMethod(classFile);
            this.generatePerTypeWithinCreateAspectInstanceMethod(classFile);
            this.generatePerTypeWithinGetWithinTypeNameMethod(classFile);
        } else {
            throw new RuntimeException("unimplemented");
        }
    }

    private void generateMethod(ClassFile classFile, ResolvedMember member, BodyGenerator gen) {
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, world.makeMethodBinding(member), gen);
    }

    private void generateMethod(ClassFile classFile, MethodBinding methodBinding, BodyGenerator gen) {
        this.generateMethod(classFile, methodBinding, null, gen);
    }

    protected List<EclipseAttributeAdapter> makeEffectiveSignatureAttribute(ResolvedMember sig, Shadow.Kind kind, boolean weaveBody) {
        ArrayList<EclipseAttributeAdapter> l = new ArrayList<EclipseAttributeAdapter>(1);
        l.add(new EclipseAttributeAdapter(new AjAttribute.EffectiveSignatureAttribute(sig, kind, weaveBody)));
        return l;
    }

    private void generateMethod(ClassFile classFile, MethodBinding methodBinding, List additionalAttributes, BodyGenerator gen) {
        boolean b;
        int attributeNumber;
        classFile.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = classFile.contentsOffset;
        if (additionalAttributes != null) {
            ArrayList attrs = new ArrayList();
            attrs.addAll(AstUtil.getAjSyntheticAttribute());
            attrs.addAll(additionalAttributes);
            attributeNumber = classFile.generateMethodInfoAttributes(methodBinding, attrs);
        } else {
            attributeNumber = classFile.generateMethodInfoAttributes(methodBinding, AstUtil.getAjSyntheticAttribute());
        }
        int codeAttributeOffset = classFile.contentsOffset;
        classFile.generateCodeAttributeHeader();
        CodeStream codeStream = classFile.codeStream;
        MethodDeclaration md = AstUtil.makeMethodDeclaration(methodBinding);
        md.scope = this.initializerScope;
        codeStream.reset(md, classFile);
        gen.generate(codeStream);
        if (codeStream.pcToSourceMapSize == 0) {
            codeStream.recordPositionsFrom(0, 1);
        }
        boolean bl = b = (codeStream.generateAttributes & 4) != 0;
        if (codeStream.maxLocals == 0) {
            codeStream.generateAttributes &= 0xFFFFFFFB;
        }
        classFile.completeCodeAttribute(codeAttributeOffset);
        if (b) {
            codeStream.generateAttributes |= 4;
        }
        classFile.completeMethodInfo(methodBinding, methodAttributeOffset, ++attributeNumber);
    }

    private void generatePerCflowAspectOfMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, this.aspectOfMethod, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                codeStream.fieldAccess((byte)-78, world.makeFieldBinding(AjcMemberMaker.perCflowField(AspectDeclaration.this.typeX)), null);
                codeStream.invoke((byte)-74, world.makeMethodBindingForCall(AjcMemberMaker.cflowStackPeekInstance()), null);
                codeStream.checkcast(AspectDeclaration.this.binding);
                codeStream.areturn();
            }
        });
    }

    private void generatePerCflowHasAspectMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, this.hasAspectMethod, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                codeStream.fieldAccess((byte)-78, world.makeFieldBinding(AjcMemberMaker.perCflowField(AspectDeclaration.this.typeX)), null);
                codeStream.invoke((byte)-74, world.makeMethodBindingForCall(AjcMemberMaker.cflowStackIsValid()), null);
                codeStream.ireturn();
            }
        });
    }

    private void generatePerCflowPushMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, world.makeMethodBinding(AjcMemberMaker.perCflowPush(this.factory.fromBinding(this.binding))), new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                codeStream.fieldAccess((byte)-78, world.makeFieldBinding(AjcMemberMaker.perCflowField(AspectDeclaration.this.typeX)), null);
                codeStream.new_(AspectDeclaration.this.binding);
                codeStream.dup();
                codeStream.invoke((byte)-73, new MethodBinding(0, "<init>".toCharArray(), TypeBinding.VOID, new TypeBinding[0], new ReferenceBinding[0], AspectDeclaration.this.binding), null);
                codeStream.invoke((byte)-74, world.makeMethodBindingForCall(AjcMemberMaker.cflowStackPushInstance()), null);
                codeStream.return_();
            }
        });
    }

    private void generatePerCflowAjcClinitMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, world.makeMethodBinding(AjcMemberMaker.ajcPreClinitMethod(world.fromBinding(this.binding))), new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                codeStream.new_(world.makeTypeBinding(AjcMemberMaker.CFLOW_STACK_TYPE));
                codeStream.dup();
                codeStream.invoke((byte)-73, world.makeMethodBindingForCall(AjcMemberMaker.cflowStackInit()), null);
                codeStream.fieldAccess((byte)-77, world.makeFieldBinding(AjcMemberMaker.perCflowField(AspectDeclaration.this.typeX)), null);
                codeStream.return_();
            }
        });
    }

    private TypeBinding generatePerObjectInterface(ClassFile classFile) {
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        UnresolvedType interfaceTypeX = AjcMemberMaker.perObjectInterfaceType(this.typeX);
        HelperInterfaceBinding interfaceType = new HelperInterfaceBinding(this.binding, interfaceTypeX);
        world.addTypeBindingAndStoreInWorld(interfaceType);
        interfaceType.addMethod(world, AjcMemberMaker.perObjectInterfaceGet(this.typeX));
        interfaceType.addMethod(world, AjcMemberMaker.perObjectInterfaceSet(this.typeX));
        interfaceType.generateClass(this.compilationResult, classFile);
        return interfaceType;
    }

    private void generatePerTypeWithinAspectOfMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, this.aspectOfMethod, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                LocalVariableBinding theTypeVar = new LocalVariableBinding("type".toCharArray(), world.makeTypeBinding(UnresolvedType.JL_CLASS), 1, true);
                codeStream.record(theTypeVar);
                theTypeVar.recordInitializationStartPC(0);
                BranchLabel instanceFound = new BranchLabel(codeStream);
                ExceptionLabel anythingGoesWrong = new ExceptionLabel(codeStream, world.makeTypeBinding(UnresolvedType.JL_EXCEPTION));
                anythingGoesWrong.placeStart();
                codeStream.aload_0();
                codeStream.invoke((byte)-72, world.makeMethodBindingForCall(AjcMemberMaker.perTypeWithinGetInstance(AspectDeclaration.this.typeX)), null);
                LocalVariableBinding aspectInstanceVar = new LocalVariableBinding("instance".toCharArray(), world.makeTypeBinding(UnresolvedType.OBJECT), 1, false);
                aspectInstanceVar.resolvedPosition = 1;
                codeStream.record(aspectInstanceVar);
                aspectInstanceVar.recordInitializationStartPC(codeStream.position);
                codeStream.astore_1();
                codeStream.aload_1();
                codeStream.ifnonnull(instanceFound);
                codeStream.new_(world.makeTypeBinding(AjcMemberMaker.NO_ASPECT_BOUND_EXCEPTION));
                codeStream.dup();
                codeStream.ldc(AspectDeclaration.this.typeX.getName());
                codeStream.aconst_null();
                codeStream.invoke((byte)-73, world.makeMethodBindingForCall(AjcMemberMaker.noAspectBoundExceptionInit2()), null);
                codeStream.athrow();
                instanceFound.place();
                codeStream.aload_1();
                codeStream.areturn();
                anythingGoesWrong.placeEnd();
                anythingGoesWrong.place();
                codeStream.astore_1();
                codeStream.new_(world.makeTypeBinding(AjcMemberMaker.NO_ASPECT_BOUND_EXCEPTION));
                codeStream.dup();
                codeStream.invoke((byte)-73, world.makeMethodBindingForCall(AjcMemberMaker.noAspectBoundExceptionInit()), null);
                codeStream.athrow();
                theTypeVar.recordInitializationEndPC(codeStream.position);
                aspectInstanceVar.recordInitializationEndPC(codeStream.position);
            }
        });
    }

    private void generatePerObjectAspectOfMethod(ClassFile classFile, final TypeBinding interfaceType) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, this.aspectOfMethod, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                LocalVariableBinding objectVar = new LocalVariableBinding("object".toCharArray(), world.makeTypeBinding(UnresolvedType.OBJECT), 1, true);
                codeStream.record(objectVar);
                objectVar.recordInitializationStartPC(0);
                BranchLabel wrongType = new BranchLabel(codeStream);
                BranchLabel returnIt = new BranchLabel(codeStream);
                codeStream.aload_0();
                codeStream.instance_of(interfaceType);
                codeStream.ifeq(wrongType);
                codeStream.aload_0();
                codeStream.checkcast(interfaceType);
                codeStream.invoke((byte)-71, world.makeMethodBindingForCall(AjcMemberMaker.perObjectInterfaceGet(AspectDeclaration.this.typeX)), null);
                codeStream.dup();
                codeStream.ifnonnull(returnIt);
                codeStream.pop();
                wrongType.place();
                codeStream.new_(world.makeTypeBinding(AjcMemberMaker.NO_ASPECT_BOUND_EXCEPTION));
                codeStream.dup();
                codeStream.invoke((byte)-73, world.makeMethodBindingForCall(AjcMemberMaker.noAspectBoundExceptionInit()), null);
                codeStream.athrow();
                returnIt.place();
                codeStream.areturn();
                codeStream.locals[0].recordInitializationEndPC(codeStream.position);
            }
        });
    }

    private void generatePerObjectHasAspectMethod(ClassFile classFile, final TypeBinding interfaceType) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, this.hasAspectMethod, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                LocalVariableBinding objectVar = new LocalVariableBinding("object".toCharArray(), world.makeTypeBinding(UnresolvedType.OBJECT), 1, true);
                codeStream.record(objectVar);
                objectVar.recordInitializationStartPC(0);
                BranchLabel wrongType = new BranchLabel(codeStream);
                codeStream.aload_0();
                codeStream.instance_of(interfaceType);
                codeStream.ifeq(wrongType);
                codeStream.aload_0();
                codeStream.checkcast(interfaceType);
                codeStream.invoke((byte)-71, world.makeMethodBindingForCall(AjcMemberMaker.perObjectInterfaceGet(AspectDeclaration.this.typeX)), null);
                codeStream.ifnull(wrongType);
                codeStream.iconst_1();
                codeStream.ireturn();
                wrongType.place();
                codeStream.iconst_0();
                codeStream.ireturn();
                codeStream.locals[0].recordInitializationEndPC(codeStream.position);
            }
        });
    }

    private void generatePerTypeWithinHasAspectMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, this.hasAspectMethod, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                LocalVariableBinding classVariable = new LocalVariableBinding("clazz".toCharArray(), world.makeTypeBinding(UnresolvedType.JL_CLASS), 1, true);
                codeStream.record(classVariable);
                classVariable.recordInitializationStartPC(codeStream.position);
                ExceptionLabel goneBang = new ExceptionLabel(codeStream, world.makeTypeBinding(UnresolvedType.JL_EXCEPTION));
                BranchLabel noInstanceExists = new BranchLabel(codeStream);
                BranchLabel leave = new BranchLabel(codeStream);
                goneBang.placeStart();
                codeStream.aload_0();
                codeStream.invoke((byte)-72, world.makeMethodBinding(AjcMemberMaker.perTypeWithinGetInstance(AspectDeclaration.this.typeX)), null);
                codeStream.ifnull(noInstanceExists);
                codeStream.iconst_1();
                codeStream.goto_(leave);
                noInstanceExists.place();
                codeStream.iconst_0();
                leave.place();
                goneBang.placeEnd();
                codeStream.ireturn();
                goneBang.place();
                codeStream.astore_1();
                codeStream.iconst_0();
                codeStream.ireturn();
                codeStream.locals[0].recordInitializationEndPC(codeStream.position);
            }
        });
    }

    private void generatePerObjectBindMethod(ClassFile classFile, final TypeBinding interfaceType) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, AjcMemberMaker.perObjectBind(world.fromBinding(this.binding)), new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                LocalVariableBinding aspectInstanceVar = new LocalVariableBinding("aspectInstance".toCharArray(), world.makeTypeBinding(UnresolvedType.OBJECT), 1, true);
                codeStream.record(aspectInstanceVar);
                aspectInstanceVar.recordInitializationStartPC(0);
                BranchLabel wrongType = new BranchLabel(codeStream);
                codeStream.aload_0();
                codeStream.instance_of(interfaceType);
                codeStream.ifeq(wrongType);
                codeStream.aload_0();
                codeStream.checkcast(interfaceType);
                codeStream.invoke((byte)-71, world.makeMethodBindingForCall(AjcMemberMaker.perObjectInterfaceGet(AspectDeclaration.this.typeX)), null);
                codeStream.ifnonnull(wrongType);
                codeStream.aload_0();
                codeStream.checkcast(interfaceType);
                codeStream.new_(AspectDeclaration.this.binding);
                codeStream.dup();
                codeStream.invoke((byte)-73, new MethodBinding(0, "<init>".toCharArray(), TypeBinding.VOID, new TypeBinding[0], new ReferenceBinding[0], AspectDeclaration.this.binding), null);
                codeStream.invoke((byte)-71, world.makeMethodBindingForCall(AjcMemberMaker.perObjectInterfaceSet(AspectDeclaration.this.typeX)), null);
                wrongType.place();
                codeStream.return_();
                codeStream.locals[0].recordInitializationEndPC(codeStream.position);
            }
        });
    }

    private void generatePerTypeWithinGetWithinTypeNameMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, AjcMemberMaker.perTypeWithinGetWithinTypeNameMethod(world.fromBinding(this.binding), world.getWorld().isInJava5Mode()), new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                ExceptionLabel exc = new ExceptionLabel(codeStream, world.makeTypeBinding(UnresolvedType.JL_EXCEPTION));
                exc.placeStart();
                codeStream.aload_0();
                codeStream.fieldAccess((byte)-76, world.makeFieldBinding(AjcMemberMaker.perTypeWithinWithinTypeField(AspectDeclaration.this.typeX, AspectDeclaration.this.typeX)), null);
                codeStream.areturn();
            }
        });
    }

    private void generatePerTypeWithinGetInstanceMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, AjcMemberMaker.perTypeWithinGetInstance(world.fromBinding(this.binding)), new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                LocalVariableBinding theTypeVar = new LocalVariableBinding("type".toCharArray(), world.makeTypeBinding(UnresolvedType.JL_CLASS), 1, true);
                codeStream.record(theTypeVar);
                theTypeVar.recordInitializationStartPC(0);
                ExceptionLabel exc = new ExceptionLabel(codeStream, world.makeTypeBinding(UnresolvedType.JL_EXCEPTION));
                exc.placeStart();
                codeStream.aload_0();
                codeStream.ldc(NameMangler.perTypeWithinLocalAspectOf(AspectDeclaration.this.typeX));
                codeStream.aconst_null();
                TypeBinding methodTypeBinding = world.makeTypeBinding(UnresolvedType.forSignature("Ljava/lang/reflect/Method;"));
                codeStream.invoke((byte)-74, new MethodBinding(0, "getDeclaredMethod".toCharArray(), methodTypeBinding, new TypeBinding[]{world.makeTypeBinding(UnresolvedType.forSignature("Ljava/lang/String;")), world.makeTypeBinding(UnresolvedType.forSignature("[Ljava/lang/Class;"))}, new ReferenceBinding[0], (ReferenceBinding)world.makeTypeBinding(UnresolvedType.JL_CLASS)), null);
                codeStream.astore_1();
                LocalVariableBinding methodVariable = new LocalVariableBinding("method".toCharArray(), methodTypeBinding, 1, true);
                codeStream.record(methodVariable);
                methodVariable.resolvedPosition = 1;
                methodVariable.recordInitializationStartPC(codeStream.position);
                codeStream.aload_1();
                codeStream.aconst_null();
                codeStream.aconst_null();
                codeStream.invoke((byte)-74, new MethodBinding(0, "invoke".toCharArray(), world.makeTypeBinding(UnresolvedType.OBJECT), new TypeBinding[]{world.makeTypeBinding(UnresolvedType.OBJECT), world.makeTypeBinding(UnresolvedType.forSignature("[Ljava/lang/Object;"))}, new ReferenceBinding[0], (ReferenceBinding)world.makeTypeBinding(UnresolvedType.JAVA_LANG_REFLECT_METHOD)), null);
                codeStream.checkcast(world.makeTypeBinding(AspectDeclaration.this.typeX));
                codeStream.astore_2();
                LocalVariableBinding aspectInstanceVariable = new LocalVariableBinding("aspectInstance".toCharArray(), world.makeTypeBinding(AspectDeclaration.this.typeX), 1, true);
                codeStream.record(aspectInstanceVariable);
                aspectInstanceVariable.resolvedPosition = 2;
                aspectInstanceVariable.recordInitializationStartPC(codeStream.position);
                codeStream.aload_2();
                exc.placeEnd();
                codeStream.areturn();
                exc.place();
                codeStream.astore_1();
                codeStream.aconst_null();
                codeStream.areturn();
                codeStream.locals[0].recordInitializationEndPC(codeStream.position);
                codeStream.locals[1].recordInitializationEndPC(codeStream.position);
                codeStream.locals[2].recordInitializationEndPC(codeStream.position);
            }
        });
    }

    private void generatePerTypeWithinCreateAspectInstanceMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, AjcMemberMaker.perTypeWithinCreateAspectInstance(world.fromBinding(this.binding)), new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                codeStream.new_(world.makeTypeBinding(AspectDeclaration.this.typeX));
                codeStream.dup();
                codeStream.invoke((byte)-73, new MethodBinding(0, "<init>".toCharArray(), TypeBinding.VOID, new TypeBinding[0], new ReferenceBinding[0], AspectDeclaration.this.binding), null);
                codeStream.astore_1();
                codeStream.aload_1();
                codeStream.aload_0();
                codeStream.fieldAccess((byte)-75, world.makeFieldBinding(AjcMemberMaker.perTypeWithinWithinTypeField(AspectDeclaration.this.typeX, AspectDeclaration.this.typeX)), null);
                codeStream.aload_1();
                codeStream.areturn();
            }
        });
    }

    private void generatePerSingletonAspectOfMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, this.aspectOfMethod, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                FieldBinding fb = world.makeFieldBinding(AjcMemberMaker.perSingletonField(AspectDeclaration.this.typeX));
                codeStream.fieldAccess((byte)-78, fb, null);
                BranchLabel isNonNull = new BranchLabel(codeStream);
                codeStream.ifnonnull(isNonNull);
                codeStream.new_(world.makeTypeBinding(AjcMemberMaker.NO_ASPECT_BOUND_EXCEPTION));
                codeStream.dup();
                codeStream.ldc(AspectDeclaration.this.typeX.getNameAsIdentifier());
                codeStream.fieldAccess((byte)-78, AspectDeclaration.this.initFailureField, null);
                codeStream.invoke((byte)-73, world.makeMethodBindingForCall(AjcMemberMaker.noAspectBoundExceptionInitWithCause()), null);
                codeStream.athrow();
                isNonNull.place();
                codeStream.fieldAccess((byte)-78, fb, null);
                codeStream.areturn();
            }
        });
    }

    private void generatePerSingletonHasAspectMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, this.hasAspectMethod, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                codeStream.fieldAccess((byte)-78, world.makeFieldBinding(AjcMemberMaker.perSingletonField(AspectDeclaration.this.typeX)), null);
                BranchLabel isNull = new BranchLabel(codeStream);
                codeStream.ifnull(isNull);
                codeStream.iconst_1();
                codeStream.ireturn();
                isNull.place();
                codeStream.iconst_0();
                codeStream.ireturn();
            }
        });
    }

    private void generatePerSingletonAjcClinitMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, world.makeMethodBinding(AjcMemberMaker.ajcPostClinitMethod(world.fromBinding(this.binding))), new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                codeStream.new_(AspectDeclaration.this.binding);
                codeStream.dup();
                codeStream.invoke((byte)-73, new MethodBinding(0, "<init>".toCharArray(), TypeBinding.VOID, new TypeBinding[0], new ReferenceBinding[0], AspectDeclaration.this.binding), null);
                codeStream.fieldAccess((byte)-77, world.makeFieldBinding(AjcMemberMaker.perSingletonField(AspectDeclaration.this.typeX)), null);
                codeStream.return_();
            }
        });
    }

    private void generateSuperAccessMethod(ClassFile classFile, final MethodBinding accessMethod, final ResolvedMember method) {
        this.generateMethod(classFile, accessMethod, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                codeStream.aload_0();
                AstUtil.generateParameterLoads(accessMethod.parameters, codeStream, 1);
                codeStream.invoke((byte)-73, AspectDeclaration.this.factory.makeMethodBinding(method), null);
                AstUtil.generateReturn(accessMethod.returnType, codeStream);
            }
        });
    }

    private void generateInlineAccessMethod(ClassFile classFile, Binding binding, ResolvedMember member) {
        if (binding instanceof InlineAccessFieldBinding) {
            this.generateInlineAccessors(classFile, (InlineAccessFieldBinding)binding, member);
        } else {
            this.generateInlineAccessMethod(classFile, (MethodBinding)binding, member);
        }
    }

    private void generateInlineAccessors(ClassFile classFile, final InlineAccessFieldBinding accessField, final ResolvedMember field) {
        final FieldBinding fieldBinding = this.factory.makeFieldBinding(field);
        this.generateMethod(classFile, accessField.reader, this.makeEffectiveSignatureAttribute(field, Shadow.FieldGet, false), new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                if (Modifier.isStatic(field.getModifiers())) {
                    codeStream.fieldAccess((byte)-78, fieldBinding, null);
                } else {
                    codeStream.aload_0();
                    codeStream.fieldAccess((byte)-76, fieldBinding, null);
                }
                AstUtil.generateReturn(accessField.reader.returnType, codeStream);
            }
        });
        this.generateMethod(classFile, accessField.writer, this.makeEffectiveSignatureAttribute(field, Shadow.FieldSet, false), new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                if (Modifier.isStatic(field.getModifiers())) {
                    codeStream.load(fieldBinding.type, 0);
                    codeStream.fieldAccess((byte)-77, fieldBinding, null);
                } else {
                    codeStream.aload_0();
                    codeStream.load(fieldBinding.type, 1);
                    codeStream.fieldAccess((byte)-75, fieldBinding, null);
                }
                codeStream.return_();
            }
        });
    }

    private void generateInlineAccessMethod(ClassFile classFile, final MethodBinding accessMethod, final ResolvedMember method) {
        this.generateMethod(classFile, accessMethod, this.makeEffectiveSignatureAttribute(method, Shadow.MethodCall, false), new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                AstUtil.generateParameterLoads(accessMethod.parameters, codeStream);
                if (Modifier.isStatic(method.getModifiers())) {
                    codeStream.invoke((byte)-72, AspectDeclaration.this.factory.makeMethodBinding(method), null);
                } else {
                    codeStream.invoke((byte)-74, AspectDeclaration.this.factory.makeMethodBinding(method), null);
                }
                AstUtil.generateReturn(accessMethod.returnType, codeStream);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PerClause.Kind lookupPerClauseKind(ReferenceBinding binding) {
        PerClause perClause;
        if (binding instanceof BinaryTypeBinding) {
            ResolvedType superTypeX = this.factory.fromEclipse(binding);
            perClause = superTypeX.getPerClause();
        } else if (binding instanceof SourceTypeBinding) {
            SourceTypeBinding sourceSc = (SourceTypeBinding)binding;
            if (!(sourceSc.scope.referenceContext instanceof AspectDeclaration)) return null;
            perClause = ((AspectDeclaration)sourceSc.scope.referenceContext).perClause;
        } else {
            if (!(binding instanceof ParameterizedTypeBinding)) return null;
            ParameterizedTypeBinding pBinding = (ParameterizedTypeBinding)binding;
            if (pBinding.type instanceof SourceTypeBinding) {
                SourceTypeBinding sourceSc = (SourceTypeBinding)pBinding.type;
                if (sourceSc.scope == null || !(sourceSc.scope.referenceContext instanceof AspectDeclaration)) return null;
                perClause = ((AspectDeclaration)sourceSc.scope.referenceContext).perClause;
            } else {
                perClause = null;
            }
        }
        if (perClause != null) return perClause.getKind();
        return this.lookupPerClauseKind(binding.superclass());
    }

    private void buildPerClause(ClassScope scope) {
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(scope);
        if (this.perClause == null) {
            PerClause.Kind kind = this.lookupPerClauseKind(this.binding.superclass);
            this.perClause = kind == null ? new PerSingleton() : new PerFromSuper(kind);
        }
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        if (!this.isAbstract()) {
            if (this.perClause.getKind() == PerClause.SINGLETON) {
                this.aspectOfMethod = AjcMemberMaker.perSingletonAspectOfMethod(this.typeX);
                this.hasAspectMethod = AjcMemberMaker.perSingletonHasAspectMethod(this.typeX);
            } else if (this.perClause.getKind() == PerClause.PERCFLOW) {
                this.aspectOfMethod = AjcMemberMaker.perCflowAspectOfMethod(this.typeX);
                this.hasAspectMethod = AjcMemberMaker.perCflowHasAspectMethod(this.typeX);
            } else if (this.perClause.getKind() == PerClause.PEROBJECT) {
                this.aspectOfMethod = AjcMemberMaker.perObjectAspectOfMethod(this.typeX);
                this.hasAspectMethod = AjcMemberMaker.perObjectHasAspectMethod(this.typeX);
            } else if (this.perClause.getKind() == PerClause.PERTYPEWITHIN) {
                this.aspectOfMethod = AjcMemberMaker.perTypeWithinAspectOfMethod(this.typeX, world.getWorld().isInJava5Mode());
                this.hasAspectMethod = AjcMemberMaker.perTypeWithinHasAspectMethod(this.typeX, world.getWorld().isInJava5Mode());
                this.ptwGetWithinTypeNameMethod = AjcMemberMaker.perTypeWithinGetWithinTypeNameMethod(this.typeX, world.getWorld().isInJava5Mode());
                this.binding.addMethod(world.makeMethodBinding(this.ptwGetWithinTypeNameMethod));
            } else {
                throw new RuntimeException("bad per clause: " + this.perClause);
            }
            this.binding.addMethod(world.makeMethodBinding(this.aspectOfMethod));
            this.binding.addMethod(world.makeMethodBinding(this.hasAspectMethod));
        }
        this.resolvePerClause();
    }

    private PerClause resolvePerClause() {
        EclipseScope iscope = new EclipseScope(new FormalBinding[0], this.scope);
        this.perClause.resolve(iscope);
        return this.perClause;
    }

    public void processIntertypeMemberTypes(ClassScope classScope) {
        this.factory = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        if (this.memberTypes != null) {
            for (int i = 0; i < this.memberTypes.length; ++i) {
                EclipseTypeMunger m;
                if (!(this.memberTypes[i] instanceof IntertypeMemberClassDeclaration) || (m = ((IntertypeMemberClassDeclaration)this.memberTypes[i]).build(classScope)) == null) continue;
                this.mungeNewInnerClass(m, this.factory);
                this.concreteName.typeMungers.add(m);
            }
        }
    }

    public void buildInterTypeAndPerClause(ClassScope classScope) {
        this.factory = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        if (this.isPrivileged) {
            this.binding.privilegedHandler = new PrivilegedHandler(this);
        }
        this.checkSpec(classScope);
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        this.buildPerClause(this.scope);
        if (this.methods != null) {
            for (int i = 0; i < this.methods.length; ++i) {
                Declare d;
                if (this.methods[i] instanceof InterTypeDeclaration) {
                    EclipseTypeMunger m = ((InterTypeDeclaration)this.methods[i]).build(classScope);
                    if (m == null) continue;
                    this.concreteName.typeMungers.add(m);
                    continue;
                }
                if (!(this.methods[i] instanceof DeclareDeclaration) || (d = ((DeclareDeclaration)this.methods[i]).build(classScope)) == null) continue;
                this.concreteName.declares.add(d);
            }
        }
        this.concreteName.getDeclaredPointcuts();
    }

    private void mungeNewInnerClass(EclipseTypeMunger m, EclipseFactory world) {
        NewMemberClassTypeMunger munger = (NewMemberClassTypeMunger)m.getMunger();
        SourceTypeBinding aspectTypeBinding = (SourceTypeBinding)world.makeTypeBinding(m.getAspectType());
        char[] mungerMemberTypeName = ("$" + munger.getMemberTypeName()).toCharArray();
        ReferenceBinding innerTypeBinding = null;
        for (ReferenceBinding innerType : aspectTypeBinding.memberTypes) {
            char[] compounded = CharOperation.concatWith(innerType.compoundName, '.');
            if (!CharOperation.endsWith(compounded, mungerMemberTypeName)) continue;
            innerTypeBinding = innerType;
            break;
        }
        if (innerTypeBinding instanceof UnresolvedReferenceBinding) {
            innerTypeBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(innerTypeBinding, world.getLookupEnvironment(), true);
        }
        if (innerTypeBinding == null) {
            throw new IllegalStateException("Could not find inner type binding for '" + munger.getMemberTypeName() + "'");
        }
        SourceTypeBinding targetSourceTypeBinding = (SourceTypeBinding)world.makeTypeBinding(munger.getTargetType());
        if (!(targetSourceTypeBinding instanceof BinaryTypeBinding)) {
            ReferenceBinding[] existingMemberTypes = targetSourceTypeBinding.memberTypes();
            for (int i = 0; i < existingMemberTypes.length; ++i) {
                char[] compounded = CharOperation.concatWith(existingMemberTypes[i].compoundName, '.');
                if (!CharOperation.endsWith(compounded, mungerMemberTypeName)) continue;
                this.scope.problemReporter().signalError(this.sourceStart(), this.sourceEnd(), "target type already declares a member type with the name '" + munger.getMemberTypeName() + "'");
                return;
            }
        }
        this.findOrCreateInterTypeMemberClassFinder(targetSourceTypeBinding).addInterTypeMemberType(innerTypeBinding);
    }

    private IntertypeMemberTypeFinder findOrCreateInterTypeMemberClassFinder(SourceTypeBinding sourceType) {
        IntertypeMemberTypeFinder finder = (IntertypeMemberTypeFinder)sourceType.typeFinder;
        if (finder == null) {
            finder = new IntertypeMemberTypeFinder();
            sourceType.typeFinder = finder;
            finder.targetTypeBinding = sourceType;
            sourceType.tagBits &= 0xFFFFFFFFFFFEFFFFL;
        }
        return finder;
    }

    @Override
    public StringBuffer printHeader(int indent, StringBuffer output) {
        AspectDeclaration.printModifiers(this.declaredModifiers, output);
        output.append("aspect ");
        output.append(this.name);
        if (this.superclass != null) {
            output.append(" extends ");
            this.superclass.print(0, output);
        }
        if (this.superInterfaces != null && this.superInterfaces.length > 0) {
            output.append(TypeDeclaration.kind(this.modifiers) == 2 ? " extends " : " implements ");
            for (int i = 0; i < this.superInterfaces.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                this.superInterfaces[i].print(0, output);
            }
        }
        return output;
    }

    public int getDeclaredModifiers() {
        return this.declaredModifiers;
    }

    @Override
    public char[] getLocalTypeNameSuffix() {
        return this.name;
    }

    private static interface BodyGenerator {
        public void generate(CodeStream var1);
    }
}

