/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.apache.bcel.classfile.annotation.ArrayElementValue;
import org.aspectj.apache.bcel.classfile.annotation.ElementNameValuePair;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;
import org.aspectj.apache.bcel.classfile.annotation.EnumElementValue;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationNameValuePair;
import org.aspectj.weaver.AnnotationValue;
import org.aspectj.weaver.ArrayAnnotationValue;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;

public class AnnotationX {
    public static final AnnotationX[] NONE = new AnnotationX[0];
    private Annotation theRealBcelAnnotation;
    private AnnotationAJ theRealEclipseAnnotation;
    private int mode = -1;
    private static final int MODE_ECLIPSE = 1;
    private static final int MODE_BCEL = 2;
    private ResolvedType signature = null;
    private boolean lookedForAtTargetAnnotation = false;
    private AnnotationX atTargetAnnotation = null;
    private Set supportedTargets = null;

    public AnnotationX(Annotation a, World world) {
        this.theRealBcelAnnotation = a;
        this.signature = UnresolvedType.forSignature(this.theRealBcelAnnotation.getTypeSignature()).resolve(world);
        this.mode = 2;
    }

    public AnnotationX(AnnotationAJ a, World world) {
        this.theRealEclipseAnnotation = a;
        this.signature = UnresolvedType.forSignature(this.theRealEclipseAnnotation.getTypeSignature()).resolve(world);
        this.mode = 1;
    }

    public Annotation getBcelAnnotation() {
        return this.theRealBcelAnnotation;
    }

    public UnresolvedType getSignature() {
        return this.signature;
    }

    public String toString() {
        if (this.mode == 2) {
            return this.theRealBcelAnnotation.toString();
        }
        return this.theRealEclipseAnnotation.toString();
    }

    public String getTypeName() {
        if (this.mode == 2) {
            return this.theRealBcelAnnotation.getTypeName();
        }
        return Utility.signatureToString(this.theRealEclipseAnnotation.getTypeSignature());
    }

    public String getTypeSignature() {
        if (this.mode == 2) {
            return this.theRealBcelAnnotation.getTypeSignature();
        }
        return this.theRealEclipseAnnotation.getTypeSignature();
    }

    public boolean allowedOnAnnotationType() {
        this.ensureAtTargetInitialized();
        if (this.atTargetAnnotation == null) {
            return true;
        }
        return this.supportedTargets.contains("ANNOTATION_TYPE");
    }

    public boolean specifiesTarget() {
        this.ensureAtTargetInitialized();
        return this.atTargetAnnotation != null;
    }

    public boolean allowedOnRegularType() {
        this.ensureAtTargetInitialized();
        if (this.atTargetAnnotation == null) {
            return true;
        }
        return this.supportedTargets.contains("TYPE");
    }

    public String stringify() {
        return this.signature.getName();
    }

    public String getValidTargets() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        Iterator iter = this.supportedTargets.iterator();
        while (iter.hasNext()) {
            String evalue = (String)iter.next();
            sb.append(evalue);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private AnnotationX retrieveAnnotationOnAnnotation(UnresolvedType requiredAnnotationSignature) {
        AnnotationX[] annos = this.signature.getAnnotations();
        for (int i = 0; i < annos.length; ++i) {
            AnnotationX annotationX = annos[i];
            if (!annotationX.getSignature().equals(requiredAnnotationSignature)) continue;
            return annos[i];
        }
        return null;
    }

    private void ensureAtTargetInitialized() {
        if (!this.lookedForAtTargetAnnotation) {
            this.lookedForAtTargetAnnotation = true;
            this.atTargetAnnotation = this.retrieveAnnotationOnAnnotation(UnresolvedType.AT_TARGET);
            if (this.atTargetAnnotation != null) {
                this.supportedTargets = this.atTargetAnnotation.getTargets();
            }
        }
    }

    public Set getTargets() {
        if (!this.signature.equals(UnresolvedType.AT_TARGET)) {
            return null;
        }
        HashSet<String> supportedTargets = new HashSet<String>();
        if (this.mode == 2) {
            List values = this.getBcelAnnotation().getValues();
            ElementNameValuePair envp = (ElementNameValuePair)values.get(0);
            ArrayElementValue aev = (ArrayElementValue)envp.getValue();
            ElementValue[] evs = aev.getElementValuesArray();
            for (int i = 0; i < evs.length; ++i) {
                EnumElementValue ev = (EnumElementValue)evs[i];
                supportedTargets.add(ev.getEnumValueString());
            }
        } else {
            List values = this.theRealEclipseAnnotation.getNameValuePairs();
            AnnotationNameValuePair nvp = (AnnotationNameValuePair)values.get(0);
            ArrayAnnotationValue aav = (ArrayAnnotationValue)nvp.getValue();
            AnnotationValue[] avs = aav.getValues();
            for (int i = 0; i < avs.length; ++i) {
                AnnotationValue value = avs[i];
                supportedTargets.add(value.stringify());
            }
        }
        return supportedTargets;
    }

    public boolean allowedOnField() {
        this.ensureAtTargetInitialized();
        if (this.atTargetAnnotation == null) {
            return true;
        }
        return this.supportedTargets.contains("FIELD");
    }

    public boolean isRuntimeVisible() {
        return this.theRealBcelAnnotation.isRuntimeVisible();
    }

    public void print(StringBuffer sb) {
        if (this.mode == 2) {
            sb.append(this.theRealBcelAnnotation.toString());
        } else {
            sb.append(this.theRealEclipseAnnotation.stringify());
        }
    }

    public boolean hasNameValuePair(String n, String v) {
        if (this.mode == 2) {
            return this.theRealBcelAnnotation.hasNameValuePair(n, v);
        }
        return this.theRealEclipseAnnotation.hasNameValuePair(n, v);
    }

    public boolean hasNamedValue(String n) {
        if (this.mode == 2) {
            return this.theRealBcelAnnotation.hasNamedValue(n);
        }
        return this.theRealEclipseAnnotation.hasNamedValue(n);
    }
}

