/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.osgi.framework.AdminPermission;

final class AdminPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 3906372644575328048L;
    private Hashtable permissions = new Hashtable();

    public void add(Permission permission) {
        if (!(permission instanceof AdminPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly AdminCollection");
        }
        AdminPermission ap = (AdminPermission)permission;
        AdminPermission existing = (AdminPermission)this.permissions.get(ap.getName());
        if (existing != null) {
            int oldMask = existing.action_mask;
            int newMask = ap.action_mask;
            if (oldMask != newMask) {
                this.permissions.put(existing.getName(), new AdminPermission(existing.getName(), oldMask | newMask));
            }
        } else {
            this.permissions.put(ap.getName(), ap);
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof AdminPermission)) {
            return false;
        }
        AdminPermission target = (AdminPermission)permission;
        Iterator permItr = this.permissions.values().iterator();
        while (permItr.hasNext()) {
            if (!((AdminPermission)permItr.next()).implies(target)) continue;
            return true;
        }
        return false;
    }

    public Enumeration elements() {
        return Collections.enumeration(this.permissions.values());
    }
}

