/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.cli.jruby;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.asciidoctor.cli.AsciidoctorCliOptions;
import org.asciidoctor.jruby.internal.JRubyAsciidoctor;
import org.asciidoctor.jruby.internal.RubyGemsPreloader;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.runtime.builtin.IRubyObject;

public class AsciidoctorRubyInvoker {
    private final JRubyAsciidoctor asciidoctor;
    private final Ruby ruby;
    private final RubyClass invokerClass;

    public AsciidoctorRubyInvoker(JRubyAsciidoctor asciidoctor) {
        this.asciidoctor = asciidoctor;
        this.ruby = asciidoctor.getRubyRuntime();
        this.invokerClass = this.ruby.getModule("AsciidoctorJ").getModule("Cli").getClass("Invoker");
    }

    public void invoke(List<File> inputFiles, AsciidoctorCliOptions cliOptions) {
        RubyHash opts = cliOptions.parse(this.ruby);
        new RubyGemsPreloader(this.asciidoctor.getRubyRuntime()).preloadRequiredLibraries((Map)opts);
        opts.put((Object)this.ruby.newSymbol("input_files"), inputFiles.stream().map(f -> this.ruby.newString(f.getPath())).collect(Collectors.toList()));
        IRubyObject invoker = this.invokerClass.newInstance(this.ruby.getCurrentContext(), (IRubyObject)opts);
        invoker.callMethod(this.ruby.getCurrentContext(), "invoke!");
    }
}

