/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.common;

import java.io.Serializable;
import org.artifactory.common.StatusEntryLevel;

public class StatusEntry
implements Serializable {
    private final int statusCode;
    private final StatusEntryLevel level;
    private final String message;
    private final Throwable exception;

    public StatusEntry(int statusCode, String message) {
        this(statusCode, StatusEntryLevel.INFO, message, null);
    }

    public StatusEntry(int statusCode, String message, Throwable exception) {
        this(statusCode, StatusEntryLevel.ERROR, message, exception);
    }

    public StatusEntry(int statusCode, StatusEntryLevel level, String message, Throwable exception) {
        if (level == null) {
            throw new IllegalArgumentException("Cannot create status entry '" + message + "' with null level");
        }
        this.statusCode = statusCode;
        this.level = level;
        this.message = message;
        this.exception = exception;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean isWarning() {
        return this.level.isWarning();
    }

    public boolean isError() {
        return this.level.isError();
    }

    public boolean isDebug() {
        return this.level.isDebug();
    }

    public boolean isInfo() {
        return this.level.isInfo();
    }

    public StatusEntryLevel getLevel() {
        return this.level;
    }

    public String toString() {
        return "StatusMessage{statusCode=" + this.statusCode + ", level=" + this.level.name() + ", statusMsg='" + this.message + "', exception=" + this.exception + "}";
    }
}

