/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.checksum;

import com.google.common.collect.ImmutableList;
import java.util.List;

public enum ChecksumType {
    sha1("SHA-1", ".sha1", 40),
    md5("MD5", ".md5", 32),
    sha256("SHA-256", ".sha256", 64);

    public static final List<ChecksumType> BASE_CHECKSUM_TYPES;
    private final String alg;
    private final String ext;
    private final int length;
    private final String validationRegex;

    private ChecksumType(String alg, String ext, int length) {
        this.alg = alg;
        this.ext = ext;
        this.length = length;
        this.validationRegex = "[a-fA-F0-9]{" + length + "}";
    }

    public String alg() {
        return this.alg;
    }

    public String ext() {
        return this.ext;
    }

    public int length() {
        return this.length;
    }

    public boolean isValid(String candidate) {
        if (candidate == null || candidate.length() != this.length) {
            return false;
        }
        return candidate.matches(this.validationRegex);
    }

    public static ChecksumType forFilePath(String filePath) {
        if (filePath == null) {
            return null;
        }
        if (filePath.endsWith(ChecksumType.sha1.ext)) {
            return sha1;
        }
        if (filePath.endsWith(ChecksumType.sha256.ext)) {
            return sha256;
        }
        if (filePath.endsWith(ChecksumType.md5.ext)) {
            return md5;
        }
        return null;
    }

    public String toString() {
        return this.alg;
    }

    public static ChecksumType forAlgorithm(String algorithm) {
        for (ChecksumType type : ChecksumType.values()) {
            if (!type.alg.equalsIgnoreCase(algorithm)) continue;
            return type;
        }
        throw new IllegalArgumentException("No checksum type exists for algorithm '" + algorithm + "'");
    }

    static {
        BASE_CHECKSUM_TYPES = ImmutableList.of((Object)((Object)sha1), (Object)((Object)md5), (Object)((Object)sha256));
    }
}

