/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.checksum;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import org.artifactory.checksum.ChecksumType;

@XStreamAlias(value="checksum")
public class ChecksumInfo
implements Serializable {
    public static final String TRUSTED_FILE_MARKER = "NO_ORIG";
    private final ChecksumType type;
    private final String original;
    private final String actual;

    public ChecksumInfo(ChecksumType type, String original, String actual) {
        this.type = type;
        if (actual != null && !type.isValid(actual)) {
            throw new IllegalStateException("Actual " + type + " checksum invalid: '" + actual + "' : '" + original + "'");
        }
        this.original = this.normalize(original);
        this.actual = actual;
    }

    public ChecksumType getType() {
        return this.type;
    }

    public String getOriginal() {
        if (this.isMarkedAsTrusted()) {
            return this.getActual();
        }
        return this.original;
    }

    public String getOriginalOrNoOrig() {
        return this.original;
    }

    public String getActual() {
        return this.actual;
    }

    public boolean checksumsMatch() {
        return this.original != null && this.actual != null && (this.isMarkedAsTrusted() || this.actual.equals(this.original));
    }

    private String normalize(String candidate) {
        return this.type.isValid(candidate) ? candidate.toLowerCase() : candidate;
    }

    public boolean isMarkedAsTrusted() {
        return TRUSTED_FILE_MARKER.equals(this.original);
    }

    public boolean isIdentical(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChecksumInfo info = (ChecksumInfo)o;
        if (this.type != info.type) {
            return false;
        }
        if (this.actual != null ? !this.actual.equals(info.actual) : info.actual != null) {
            return false;
        }
        return this.original != null ? this.original.equals(info.original) : info.original == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChecksumInfo info = (ChecksumInfo)o;
        return this.type == info.type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return "ChecksumInfo{type=" + this.type + ", original='" + this.original + "', actual='" + this.actual + "'}";
    }
}

