/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.checksum;

import org.artifactory.util.PathUtils;

public enum ChecksumType {
    sha1("SHA-1", ".sha1", 40),
    md5("MD5", ".md5", 32);

    private final String alg;
    private final String ext;
    private final int length;

    private ChecksumType(String alg, String ext, int length) {
        this.alg = alg;
        this.ext = ext;
        this.length = length;
    }

    public String alg() {
        return this.alg;
    }

    public String ext() {
        return this.ext;
    }

    public int length() {
        return this.length;
    }

    public boolean isValid(String candidate) {
        if (candidate == null || candidate.length() != this.length) {
            return false;
        }
        return candidate.matches("[a-fA-F0-9]{" + this.length + "}");
    }

    public static ChecksumType forExtension(String ext) {
        if (ChecksumType.sha1.ext.equals(ext)) {
            return sha1;
        }
        if (ChecksumType.md5.ext.equals(ext)) {
            return md5;
        }
        return null;
    }

    public static ChecksumType forFilePath(String filePath) {
        String extension = String.valueOf('.') + PathUtils.getExtension(filePath);
        return ChecksumType.forExtension(extension);
    }

    public String toString() {
        return this.alg;
    }
}

