/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.request;

import org.artifactory.checksum.ChecksumType;
import org.artifactory.request.Request;

public interface ArtifactoryRequest
extends Request {
    @Deprecated
    public static final String ORIGIN_ARTIFACTORY = "Origin-Artifactory";
    public static final String ARTIFACTORY_ORIGINATED = "X-Artifactory-Originated";
    public static final String ARTIFACTORY_OVERRIDE_BASE_URL = "X-Artifactory-Override-Base-Url";
    public static final String JFROG_OVERRIDE_BASE_URL = "X-JFrog-Override-Base-Url";
    public static final String ORIGINAL_CLIENT_URI = "X-Orig-Client-Uri";
    public static final String CHECKSUM_SHA1 = "X-Checksum-Sha1";
    public static final String CHECKSUM_SHA256 = "X-Checksum-Sha256";
    public static final String CHECKSUM = "X-Checksum";
    public static final String CHECKSUM_MD5 = "X-Checksum-Md5";
    public static final String ACCEPT_RANGES = "Accept-Ranges";
    public static final String FILE_NAME = "X-Artifactory-Filename";
    public static final String CHECKSUM_DEPLOY = "X-Checksum-Deploy";
    public static final String CHECK_BINARY_EXISTENCE_IN_FILESTORE = "X-Check-Binary-Existence-In-Filestore";
    public static final String EXPLODE_ARCHIVE = "X-Explode-Archive";
    public static final String EXPLODE_ARCHIVE_ATOMIC = "X-Explode-Archive-Atomic";
    public static final String RESULT_DETAIL = "X-Result-Detail";
    public static final String PARAM_SKIP_JAR_INDEXING = "artifactory.skipJarIndexing";
    public static final String PARAM_FORCE_DOWNLOAD_IF_NEWER = "artifactory.forceDownloadIfNewer";
    public static final String PARAM_FORCE_GET_STREAM = "artifactory.disableRedirect";
    public static final String PARAM_SEARCH_FOR_EXISTING_RESOURCE_ON_REMOTE_REQUEST = "artifactory.searchForExistingResourceOnRemoteRequest";
    public static final String PARAM_ALTERNATIVE_REMOTE_DOWNLOAD_URL = "artifactory.alternativeRemoteDownloadUrl";
    public static final String PARAM_ALTERNATIVE_REMOTE_SITE_URL = "artifactory.alternativeRemoteSiteUrl";
    public static final String PARAM_REPLICATION_DOWNLOAD_REQUEST = "artifactory.replicationDownloadRequest";
    public static final String PARAM_REPLICATION_ORIGINATED_DOWNLOAD_REQUEST = "artifactory.replicationOriginatedDownloadRequest";
    public static final String PARAM_FOLDER_REDIRECT_ASSERTION = "artifactory.disableFolderRedirectAssertion";
    public static final String PARAM_REPLACE_HEAD_IN_RETRIEVE_INFO_WITH_GET = "artifactory.replaceHeadInRetrieveInfoWithGet";
    public static final String PARAM_SKIP_ENCODING = "artifactory.skipEncoding";
    public static final String LIST_BROWSING_PATH = "list";
    public static final String SIMPLE_BROWSING_PATH = "simple";
    public static final String LAST_MODIFIED = "X-Artifactory-Last-Modified";
    public static final String CREATED = "X-Artifactory-Created";
    public static final String MODIFIED_BY = "X-Artifactory-Modified-By";
    public static final String CREATED_BY = "X-Artifactory-Created-By";

    public String getRepoKey();

    public String getPath();

    public boolean isMetadata();

    public boolean isRecursive();

    public long getModificationTime();

    public String getName();

    public boolean isDirectoryRequest();

    public static String headerForChecksum(ChecksumType checksumType) {
        switch (checksumType) {
            case sha1: {
                return CHECKSUM_SHA1;
            }
            case sha256: {
                return CHECKSUM_SHA256;
            }
            case md5: {
                return CHECKSUM_MD5;
            }
        }
        return "";
    }
}

