/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.result.rows;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.artifactory.aql.model.AqlPhysicalFieldEnum;
import org.artifactory.aql.model.DomainSensitiveField;
import org.artifactory.aql.result.rows.RowResult;
import org.artifactory.checksum.ChecksumInfo;
import org.artifactory.checksum.ChecksumType;
import org.artifactory.factory.InfoFactoryHolder;
import org.artifactory.fs.FileInfo;
import org.artifactory.fs.MutableFileInfo;
import org.artifactory.repo.RepoPath;
import org.artifactory.repo.RepoPathFactory;

public class FileInfoItemRow
implements RowResult {
    protected long itemId;
    protected String repo;
    protected String path;
    protected String name;
    protected long size;
    protected long modified;
    protected long created;
    protected long updated;
    protected String createdBy;
    protected String modifiedBy;
    protected String originalMd5;
    protected String actualMd5;
    protected String originalSha1;
    protected String actualSha1;
    protected String sha2;
    protected String propKey;
    protected String propVal;

    @Override
    public void put(DomainSensitiveField field, Object value) {
        if (!(field.getField() instanceof AqlPhysicalFieldEnum)) {
            return;
        }
        AqlPhysicalFieldEnum physicalField = (AqlPhysicalFieldEnum)field.getField();
        switch (physicalField) {
            case itemId: {
                this.itemId = (Long)value;
                break;
            }
            case itemRepo: {
                this.repo = (String)value;
                break;
            }
            case itemPath: {
                this.path = (String)value;
                break;
            }
            case itemName: {
                this.name = (String)value;
                break;
            }
            case itemSize: {
                this.size = (Long)value;
                break;
            }
            case itemModified: {
                this.modified = ((Date)value).getTime();
                break;
            }
            case itemCreated: {
                this.created = ((Date)value).getTime();
                break;
            }
            case itemUpdated: {
                this.updated = ((Date)value).getTime();
                break;
            }
            case itemCreatedBy: {
                this.createdBy = (String)value;
                break;
            }
            case itemModifiedBy: {
                this.modifiedBy = (String)value;
                break;
            }
            case itemOriginalMd5: {
                this.originalMd5 = (String)value;
                break;
            }
            case itemActualMd5: {
                this.actualMd5 = (String)value;
                break;
            }
            case itemOriginalSha1: {
                this.originalSha1 = (String)value;
                break;
            }
            case itemActualSha1: {
                this.actualSha1 = (String)value;
                break;
            }
            case itemSha2: {
                this.sha2 = (String)value;
                break;
            }
            case propertyKey: {
                this.propKey = (String)value;
                break;
            }
            case propertyValue: {
                this.propVal = (String)value;
                break;
            }
        }
    }

    @Override
    public Object get(DomainSensitiveField field) {
        return null;
    }

    public RepoPath getRepoPath() {
        if (StringUtils.equals((String)this.path, (String)".")) {
            return RepoPathFactory.create((String)this.repo, (String)this.name);
        }
        return RepoPathFactory.create((String)this.repo, (String)(this.path + "/" + this.name));
    }

    public FileInfo toFileInfo() {
        MutableFileInfo fileInfo = InfoFactoryHolder.get().createFileInfo(this.getRepoPath(), this.itemId);
        fileInfo.setSize(this.size);
        fileInfo.setLastModified(this.modified);
        fileInfo.setCreated(this.created);
        fileInfo.setLastUpdated(this.updated);
        fileInfo.setCreatedBy(this.createdBy);
        fileInfo.setModifiedBy(this.modifiedBy);
        HashSet checksums = Sets.newHashSet();
        checksums.add(new ChecksumInfo(ChecksumType.md5, this.originalMd5, this.actualMd5));
        checksums.add(new ChecksumInfo(ChecksumType.sha1, this.originalSha1, this.actualSha1));
        if (StringUtils.isNotBlank((String)this.sha2)) {
            checksums.add(new ChecksumInfo(ChecksumType.sha256, "NO_ORIG", this.sha2));
        }
        fileInfo.setChecksums((Set)checksums);
        return fileInfo;
    }

    @Generated
    public FileInfoItemRow() {
    }

    @Generated
    public long getItemId() {
        return this.itemId;
    }

    @Generated
    public String getRepo() {
        return this.repo;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public long getModified() {
        return this.modified;
    }

    @Generated
    public long getCreated() {
        return this.created;
    }

    @Generated
    public long getUpdated() {
        return this.updated;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    @Generated
    public String getOriginalMd5() {
        return this.originalMd5;
    }

    @Generated
    public String getActualMd5() {
        return this.actualMd5;
    }

    @Generated
    public String getOriginalSha1() {
        return this.originalSha1;
    }

    @Generated
    public String getActualSha1() {
        return this.actualSha1;
    }

    @Generated
    public String getSha2() {
        return this.sha2;
    }

    @Generated
    public String getPropKey() {
        return this.propKey;
    }

    @Generated
    public String getPropVal() {
        return this.propVal;
    }

    @Generated
    public void setItemId(long itemId) {
        this.itemId = itemId;
    }

    @Generated
    public void setRepo(String repo) {
        this.repo = repo;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSize(long size) {
        this.size = size;
    }

    @Generated
    public void setModified(long modified) {
        this.modified = modified;
    }

    @Generated
    public void setCreated(long created) {
        this.created = created;
    }

    @Generated
    public void setUpdated(long updated) {
        this.updated = updated;
    }

    @Generated
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @Generated
    public void setOriginalMd5(String originalMd5) {
        this.originalMd5 = originalMd5;
    }

    @Generated
    public void setActualMd5(String actualMd5) {
        this.actualMd5 = actualMd5;
    }

    @Generated
    public void setOriginalSha1(String originalSha1) {
        this.originalSha1 = originalSha1;
    }

    @Generated
    public void setActualSha1(String actualSha1) {
        this.actualSha1 = actualSha1;
    }

    @Generated
    public void setSha2(String sha2) {
        this.sha2 = sha2;
    }

    @Generated
    public void setPropKey(String propKey) {
        this.propKey = propKey;
    }

    @Generated
    public void setPropVal(String propVal) {
        this.propVal = propVal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileInfoItemRow)) {
            return false;
        }
        FileInfoItemRow other = (FileInfoItemRow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getItemId() != other.getItemId()) {
            return false;
        }
        String this$repo = this.getRepo();
        String other$repo = other.getRepo();
        if (this$repo == null ? other$repo != null : !this$repo.equals(other$repo)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getModified() != other.getModified()) {
            return false;
        }
        if (this.getCreated() != other.getCreated()) {
            return false;
        }
        if (this.getUpdated() != other.getUpdated()) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$modifiedBy = this.getModifiedBy();
        String other$modifiedBy = other.getModifiedBy();
        if (this$modifiedBy == null ? other$modifiedBy != null : !this$modifiedBy.equals(other$modifiedBy)) {
            return false;
        }
        String this$originalMd5 = this.getOriginalMd5();
        String other$originalMd5 = other.getOriginalMd5();
        if (this$originalMd5 == null ? other$originalMd5 != null : !this$originalMd5.equals(other$originalMd5)) {
            return false;
        }
        String this$actualMd5 = this.getActualMd5();
        String other$actualMd5 = other.getActualMd5();
        if (this$actualMd5 == null ? other$actualMd5 != null : !this$actualMd5.equals(other$actualMd5)) {
            return false;
        }
        String this$originalSha1 = this.getOriginalSha1();
        String other$originalSha1 = other.getOriginalSha1();
        if (this$originalSha1 == null ? other$originalSha1 != null : !this$originalSha1.equals(other$originalSha1)) {
            return false;
        }
        String this$actualSha1 = this.getActualSha1();
        String other$actualSha1 = other.getActualSha1();
        if (this$actualSha1 == null ? other$actualSha1 != null : !this$actualSha1.equals(other$actualSha1)) {
            return false;
        }
        String this$sha2 = this.getSha2();
        String other$sha2 = other.getSha2();
        if (this$sha2 == null ? other$sha2 != null : !this$sha2.equals(other$sha2)) {
            return false;
        }
        String this$propKey = this.getPropKey();
        String other$propKey = other.getPropKey();
        if (this$propKey == null ? other$propKey != null : !this$propKey.equals(other$propKey)) {
            return false;
        }
        String this$propVal = this.getPropVal();
        String other$propVal = other.getPropVal();
        return !(this$propVal == null ? other$propVal != null : !this$propVal.equals(other$propVal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FileInfoItemRow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $itemId = this.getItemId();
        result = result * 59 + (int)($itemId >>> 32 ^ $itemId);
        String $repo = this.getRepo();
        result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        long $modified = this.getModified();
        result = result * 59 + (int)($modified >>> 32 ^ $modified);
        long $created = this.getCreated();
        result = result * 59 + (int)($created >>> 32 ^ $created);
        long $updated = this.getUpdated();
        result = result * 59 + (int)($updated >>> 32 ^ $updated);
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $modifiedBy = this.getModifiedBy();
        result = result * 59 + ($modifiedBy == null ? 43 : $modifiedBy.hashCode());
        String $originalMd5 = this.getOriginalMd5();
        result = result * 59 + ($originalMd5 == null ? 43 : $originalMd5.hashCode());
        String $actualMd5 = this.getActualMd5();
        result = result * 59 + ($actualMd5 == null ? 43 : $actualMd5.hashCode());
        String $originalSha1 = this.getOriginalSha1();
        result = result * 59 + ($originalSha1 == null ? 43 : $originalSha1.hashCode());
        String $actualSha1 = this.getActualSha1();
        result = result * 59 + ($actualSha1 == null ? 43 : $actualSha1.hashCode());
        String $sha2 = this.getSha2();
        result = result * 59 + ($sha2 == null ? 43 : $sha2.hashCode());
        String $propKey = this.getPropKey();
        result = result * 59 + ($propKey == null ? 43 : $propKey.hashCode());
        String $propVal = this.getPropVal();
        result = result * 59 + ($propVal == null ? 43 : $propVal.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FileInfoItemRow(itemId=" + this.getItemId() + ", repo=" + this.getRepo() + ", path=" + this.getPath() + ", name=" + this.getName() + ", size=" + this.getSize() + ", modified=" + this.getModified() + ", created=" + this.getCreated() + ", updated=" + this.getUpdated() + ", createdBy=" + this.getCreatedBy() + ", modifiedBy=" + this.getModifiedBy() + ", originalMd5=" + this.getOriginalMd5() + ", actualMd5=" + this.getActualMd5() + ", originalSha1=" + this.getOriginalSha1() + ", actualSha1=" + this.getActualSha1() + ", sha2=" + this.getSha2() + ", propKey=" + this.getPropKey() + ", propVal=" + this.getPropVal() + ")";
    }
}

