/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.action;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.artifactory.api.context.ContextHelper;
import org.artifactory.api.properties.PropertiesService;
import org.artifactory.aql.action.AqlActionException;
import org.artifactory.aql.action.AqlPropertyAction;
import org.artifactory.aql.model.AqlActionEnum;
import org.artifactory.aql.model.AqlDomainEnum;
import org.artifactory.aql.result.AqlRestResult;
import org.artifactory.aql.util.AqlUtils;
import org.artifactory.descriptor.property.Property;
import org.artifactory.repo.RepoPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AqlUpdateItemPropertyAction
implements AqlPropertyAction {
    private static final Logger log = LoggerFactory.getLogger(AqlUpdateItemPropertyAction.class);
    private boolean dryRun = true;
    private List<String> propKeys = Lists.newArrayList();
    private String newValue;

    @Override
    public AqlRestResult.Row doAction(AqlRestResult.Row row) throws AqlActionException {
        if (!AqlDomainEnum.properties.equals((Object)row.getDomain())) {
            String msg = "Skipping delete action for row, only properties domain is supported - row has domain: " + row.getDomain();
            log.debug(msg);
            throw new AqlActionException(msg, AqlActionException.Reason.UNSUPPORTED_FOR_DOMAIN);
        }
        if (this.propKeys.isEmpty()) {
            String msg = "Skipping update property action for row, missing required property key inclusion";
            log.debug(msg);
            throw new AqlActionException(msg, AqlActionException.Reason.UNEXPECTED_CONTENT);
        }
        if (StringUtils.isBlank((String)row.itemRepo) && StringUtils.isBlank((String)row.itemPath) && StringUtils.isBlank((String)row.itemName)) {
            if (row.items == null) {
                throw new AqlActionException("Cannot resolve artifact path from given row.", AqlActionException.Reason.UNEXPECTED_CONTENT);
            }
            for (AqlRestResult.Row item : row.items) {
                this.updateRowProperties(AqlUtils.fromAql(item));
            }
        } else {
            this.updateRowProperties(AqlUtils.fromAql(row));
        }
        return row;
    }

    private void updateRowProperties(RepoPath itemPath) throws AqlActionException {
        if (itemPath == null) {
            throw new AqlActionException("Cannot resolve artifact path from given row.", AqlActionException.Reason.UNEXPECTED_CONTENT);
        }
        try {
            this.propKeys.stream().filter(Objects::nonNull).map(Property::new).forEach(prop -> this.getPropsService().editProperty(itemPath, null, (Property)prop, true, this.newValue));
        }
        catch (Exception e) {
            log.debug("", (Throwable)e);
            throw new AqlActionException("Failed to update properties '" + this.propKeys + "' for path " + itemPath + " with new value '" + this.newValue + "'. Check the log for more info.", AqlActionException.Reason.ACTION_FAILED);
        }
    }

    @Override
    public String getName() {
        return AqlActionEnum.updateProperty.actionName();
    }

    @Override
    public boolean supportsDomain(AqlDomainEnum domain) {
        return AqlDomainEnum.properties.equals((Object)domain);
    }

    @Override
    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @Override
    public boolean isDryRun() {
        return this.dryRun;
    }

    @Override
    public List<String> getKeys() {
        return this.propKeys;
    }

    @Override
    public void addKey(String key) {
        this.propKeys.add(key);
    }

    @Override
    public String getValue() {
        return this.newValue;
    }

    @Override
    public void setValue(String newValue) {
        this.newValue = newValue;
    }

    private PropertiesService getPropsService() {
        return ContextHelper.get().beanForType(PropertiesService.class);
    }
}

