/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.security;

import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.artifactory.api.common.BasicStatusHolder;
import org.artifactory.api.config.ImportableExportable;
import org.artifactory.api.repo.Async;
import org.artifactory.api.security.PasswordExpiryUser;
import org.artifactory.api.security.SecurityListener;
import org.artifactory.descriptor.security.ldap.LdapSetting;
import org.artifactory.sapi.common.Lock;
import org.artifactory.security.SaltedPassword;
import org.artifactory.security.SecurityInfo;
import org.artifactory.security.UserInfo;
import org.artifactory.util.SerializablePair;

public interface SecurityService
extends ImportableExportable {
    public static final String FILE_NAME = "security.xml";
    public static final String DEFAULT_ADMIN_USER = "admin";
    public static final String DEFAULT_ADMIN_PASSWORD = "password";
    public static final String USER_SYSTEM = "_system_";
    public static final String USER_XRAY = "xray";

    public SecurityInfo getSecurityData();

    @Lock
    public void importSecurityData(String var1);

    @Lock
    public void importSecurityData(String var1, boolean var2);

    @Lock
    public void importSecurityData(SecurityInfo var1);

    public void decryptAllUserProps();

    public BasicStatusHolder testLdapConnection(LdapSetting var1, String var2, String var3);

    public boolean isPasswordEncryptionEnabled();

    public boolean userPasswordMatches(String var1);

    @Async(transactional=true)
    public void generatePasswordResetKey(String var1, String var2, String var3) throws Exception;

    public SerializablePair<Date, String> getPasswordResetKeyInfo(String var1);

    public SerializablePair<String, Long> getUserLastLoginInfo(String var1);

    public boolean isHasPriorLogin();

    @Async(transactional=true)
    public void updateUserLastLogin(String var1, long var2, String var4);

    public void updateUserLastAccess(String var1, String var2, long var3);

    public boolean isHttpSsoProxied();

    public String getHttpSsoRemoteUserRequestVariable();

    public boolean isNoHttpSsoAutoUserCreation();

    public void addListener(SecurityListener var1);

    public void removeListener(SecurityListener var1);

    public void authenticateAsSystem();

    public void doAsSystem(@Nonnull Runnable var1);

    public void nullifyContext();

    public SaltedPassword generateSaltedPassword(String var1);

    public SaltedPassword generateSaltedPassword(String var1, @Nullable String var2);

    public String getDefaultSalt();

    public void interceptLoginFailure(@Nonnull String var1, long var2);

    public void interceptLoginSuccess(@Nonnull String var1);

    public void ensureUserIsNotLocked(@Nonnull String var1);

    public void ensureSessionIsNotLocked(@Nonnull String var1);

    public void ensureLoginShouldNotBeDelayed(@Nonnull String var1, long var2);

    public void ensureSessionShouldNotBeDelayed(@Nonnull String var1);

    public boolean isUserLocked(String var1);

    public void changePassword(String var1, String var2, String var3, String var4);

    public void changePasswordWithoutValidation(UserInfo var1, String var2);

    public void expireUserCredentials(String var1);

    public void unexpirePassword(String var1);

    public void expireCredentialsForAllUsers();

    public void unexpirePasswordForAllUsers();

    public Set<PasswordExpiryUser> getUsersWhichPasswordIsAboutToExpire();

    public void markUsersCredentialsExpired(int var1);

    public Integer getUserPasswordDaysLeft(String var1);

    public boolean isUserLockPolicyEnabled();

    public boolean isPasswordExpirationPolicyEnabled();

    public void resetUserMfaStatus(String var1);
}

