/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.search.artifact;

import java.util.Locale;
import org.artifactory.api.context.ContextHelper;
import org.artifactory.api.search.SearchResultBase;
import org.artifactory.fs.ItemInfo;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ArtifactSearchResult
extends SearchResultBase {
    private static final DateTimeFormatter DAY_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withLocale(Locale.ENGLISH);

    public ArtifactSearchResult(ItemInfo itemInfo) {
        super(itemInfo);
    }

    public String getLastModifiedDay() {
        return DAY_FORMAT.print(this.getLastModified());
    }

    public String getLastModifiedString() {
        long lastModified = this.getItemInfo().getLastModified();
        return ContextHelper.get().getCentralConfig().format(lastModified);
    }

    public long getLastModified() {
        return this.getItemInfo().getLastModified();
    }
}

