/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.rest.replication;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.artifactory.api.rest.replication.ReplicationStatusType;
import org.artifactory.api.rest.replication.ReplicationTarget;
import org.codehaus.jackson.annotate.JsonIgnore;

public class ReplicationStatus
implements Serializable {
    private ReplicationStatusType status;
    private String lastCompleted;
    private List<ReplicationTarget> targets;
    private Map<String, ReplicationStatus> repositories;

    public ReplicationStatus() {
    }

    public ReplicationStatus(ReplicationStatusType status, @Nullable String lastCompleted) {
        this.status = status;
        this.lastCompleted = lastCompleted;
    }

    public ReplicationStatus(ReplicationStatusType status, @Nullable String lastCompleted, Map<String, ReplicationStatus> repositories, List<ReplicationTarget> targets) {
        this.status = status;
        this.lastCompleted = lastCompleted;
        this.targets = targets;
        this.repositories = repositories;
    }

    public String getStatus() {
        return this.status.getId();
    }

    public List<ReplicationTarget> getTargets() {
        return this.targets;
    }

    @JsonIgnore
    public String getDisplayName() {
        return this.status.getDisplayName();
    }

    @JsonIgnore
    public ReplicationStatusType getType() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = ReplicationStatusType.findTypeById(status);
    }

    @Nullable
    public String getLastCompleted() {
        return this.lastCompleted;
    }

    public void setLastCompleted(@Nullable String lastCompleted) {
        this.lastCompleted = lastCompleted;
    }

    public Map<String, ReplicationStatus> getRepositories() {
        return this.repositories;
    }
}

