/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.rest.keys;

import lombok.Generated;
import org.artifactory.api.util.LongFromDateDeserializer;
import org.artifactory.api.util.LongToDateSerializer;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.jfrog.common.ArgUtils;

public class TrustedKeyResponse {
    @JsonProperty
    private String kid;
    @JsonProperty(value="key")
    private String trustedKey;
    @JsonProperty
    private String fingerprint;
    @JsonProperty
    private String alias;
    @JsonProperty(value="issued_on")
    @JsonSerialize(using=LongToDateSerializer.class)
    @JsonDeserialize(using=LongFromDateDeserializer.class)
    private Long issued;
    @JsonProperty(value="issued_by")
    private String issuedBy;
    @JsonProperty(value="valid_until")
    @JsonSerialize(using=LongToDateSerializer.class)
    @JsonDeserialize(using=LongFromDateDeserializer.class)
    private Long expiry;

    public TrustedKeyResponse() {
    }

    public TrustedKeyResponse(String kid, String trustedKey, String fingerprint, String alias, Long issued, String issuedBy, Long expiry) {
        this.kid = ArgUtils.requireNonBlank((String)kid, (String)"key ID is required");
        this.trustedKey = ArgUtils.requireNonBlank((String)trustedKey, (String)"Trusted key is required");
        this.fingerprint = ArgUtils.requireNonBlank((String)fingerprint, (String)"Fingerprint is required");
        this.alias = alias;
        this.issued = (Long)ArgUtils.requireSatisfies((Object)issued, v -> v == null || v > 0L, (String)"Issued time must be positive");
        this.issuedBy = issuedBy;
        this.expiry = (Long)ArgUtils.requireSatisfies((Object)expiry, v -> v == null || v == 0L || v > 0L && (issued == null || v > issued), (String)"Expiry should be after issue date");
    }

    public String getKid() {
        return this.kid;
    }

    public String getTrustedKey() {
        return this.trustedKey;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getAlias() {
        return this.alias;
    }

    public Long getIssued() {
        return this.issued;
    }

    public String getIssuedBy() {
        return this.issuedBy;
    }

    public Long getExpiry() {
        return this.expiry;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String toString() {
        return "TrustedKeyResponse(kid=" + this.getKid() + ", trustedKey=" + this.getTrustedKey() + ", fingerprint=" + this.getFingerprint() + ", alias=" + this.getAlias() + ", issued=" + this.getIssued() + ", issuedBy=" + this.getIssuedBy() + ", expiry=" + this.getExpiry() + ")";
    }

    public static class Builder {
        private String kid;
        private String trustedKey;
        private String fingerprint;
        private String alias;
        private Long issued;
        private String issuedBy;
        private Long expiry;

        public Builder setKid(String kid) {
            this.kid = kid;
            return this;
        }

        public Builder setTrustedKey(String trustedKey) {
            this.trustedKey = trustedKey;
            return this;
        }

        public Builder setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder setIssued(Long issued) {
            this.issued = issued;
            return this;
        }

        public Builder setIssuedBy(String issuedBy) {
            this.issuedBy = issuedBy;
            return this;
        }

        public Builder setExpiry(Long expiry) {
            this.expiry = expiry;
            return this;
        }

        public TrustedKeyResponse build() {
            return new TrustedKeyResponse(this.kid, this.trustedKey, this.fingerprint, this.alias, this.issued, this.issuedBy, this.expiry);
        }
    }
}

