/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.repo;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.artifactory.api.common.BasicStatusHolder;
import org.artifactory.api.common.MoveMultiStatusHolder;
import org.artifactory.api.config.ExportSettingsImpl;
import org.artifactory.api.config.ImportSettingsImpl;
import org.artifactory.api.config.ImportableExportable;
import org.artifactory.api.module.ModuleInfo;
import org.artifactory.api.module.VersionUnit;
import org.artifactory.api.repo.ArchiveFileContent;
import org.artifactory.api.repo.Request;
import org.artifactory.api.repo.exception.FileExpectedException;
import org.artifactory.api.repo.exception.FolderExpectedException;
import org.artifactory.api.repo.exception.ItemNotFoundRuntimeException;
import org.artifactory.api.repo.storage.FolderSummeryInfo;
import org.artifactory.api.search.SavedSearchResults;
import org.artifactory.api.search.VersionSearchResults;
import org.artifactory.checksum.ChecksumType;
import org.artifactory.common.MutableStatusHolder;
import org.artifactory.common.StatusHolder;
import org.artifactory.descriptor.repo.LocalCacheRepoDescriptor;
import org.artifactory.descriptor.repo.LocalRepoDescriptor;
import org.artifactory.descriptor.repo.RealRepoDescriptor;
import org.artifactory.descriptor.repo.RemoteRepoDescriptor;
import org.artifactory.descriptor.repo.RepoDescriptor;
import org.artifactory.descriptor.repo.RepoType;
import org.artifactory.descriptor.repo.VirtualRepoDescriptor;
import org.artifactory.descriptor.repo.distribution.DistributionRepoDescriptor;
import org.artifactory.descriptor.repo.releasebundle.ReleaseBundlesRepoDescriptor;
import org.artifactory.fs.FileInfo;
import org.artifactory.fs.FolderInfo;
import org.artifactory.fs.ItemInfo;
import org.artifactory.fs.StatsInfo;
import org.artifactory.fs.ZipEntryInfo;
import org.artifactory.md.Properties;
import org.artifactory.repo.RepoPath;
import org.artifactory.resource.ResourceStreamHandle;
import org.artifactory.sapi.common.ExportSettings;
import org.artifactory.sapi.common.Lock;
import org.artifactory.sapi.interceptor.context.DeleteContext;
import org.artifactory.util.Tree;

public interface RepositoryService
extends ImportableExportable {
    public static final String METADATA_FOLDER = ".artifactory-metadata";

    public List<LocalRepoDescriptor> getLocalRepoDescriptors();

    public List<LocalRepoDescriptor> getLocalRepoDescriptorsIncludingBuildInfo();

    public List<LocalCacheRepoDescriptor> getCachedRepoDescriptors();

    public List<VirtualRepoDescriptor> getVirtualRepoDescriptors();

    public List<DistributionRepoDescriptor> getDistributionRepoDescriptors();

    public List<ReleaseBundlesRepoDescriptor> getReleaseBundlesRepoDescriptors();

    public LocalRepoDescriptor getSupportBundlesRepoDescriptors();

    public List<RealRepoDescriptor> getLocalAndRemoteRepoDescriptors();

    public List<LocalRepoDescriptor> getLocalAndCachedRepoDescriptors();

    public List<RemoteRepoDescriptor> getRemoteRepoDescriptors();

    public RepoDescriptor repoDescriptorByKey(String var1);

    public LocalRepoDescriptor localOrCachedRepoDescriptorByKey(String var1);

    public LocalRepoDescriptor localCachedOrDistributionRepoDescriptorByKey(String var1);

    public LocalRepoDescriptor localRepoDescriptorByKey(String var1);

    public RemoteRepoDescriptor remoteRepoDescriptorByKey(String var1);

    public VirtualRepoDescriptor virtualRepoDescriptorByKey(String var1);

    public boolean isVirtualRepoExist(String var1);

    public DistributionRepoDescriptor distributionRepoDescriptorByKey(String var1);

    public ReleaseBundlesRepoDescriptor releaseBundlesRepoDescriptorByKey(String var1);

    @Nonnull
    public String getStringContent(FileInfo var1);

    @Nonnull
    public String getStringContent(RepoPath var1);

    public ResourceStreamHandle getResourceStreamHandle(RepoPath var1);

    public ArchiveFileContent getArchiveFileContent(RepoPath var1, String var2) throws IOException;

    public void importAll(ImportSettingsImpl var1);

    public void importRepo(String var1, ImportSettingsImpl var2);

    @Nonnull
    public ItemInfo getItemInfo(RepoPath var1) throws ItemNotFoundRuntimeException;

    @Nonnull
    public FileInfo getFileInfo(RepoPath var1) throws ItemNotFoundRuntimeException, FileExpectedException;

    @Nonnull
    public FolderInfo getFolderInfo(RepoPath var1) throws ItemNotFoundRuntimeException, FolderExpectedException;

    @Request(aggregateEventsByTimeWindow=true)
    @Lock
    public BasicStatusHolder undeploy(RepoPath var1);

    @Request(aggregateEventsByTimeWindow=true)
    @Lock
    public BasicStatusHolder undeploy(RepoPath var1, boolean var2);

    @Request(aggregateEventsByTimeWindow=true)
    @Lock
    public BasicStatusHolder undeploy(RepoPath var1, boolean var2, boolean var3);

    @Request(aggregateEventsByTimeWindow=true)
    @Lock
    public BasicStatusHolder undeploy(RepoPath var1, boolean var2, DeleteContext var3);

    @Request(aggregateEventsByTimeWindow=true)
    public StatusHolder undeployMultiTransaction(RepoPath var1);

    @Request(aggregateEventsByTimeWindow=true)
    public StatusHolder undeployVersionUnits(Set<VersionUnit> var1);

    @Lock
    public MoveMultiStatusHolder move(RepoPath var1, RepoPath var2, boolean var3, boolean var4, boolean var5);

    @Lock
    public MoveMultiStatusHolder move(Set<RepoPath> var1, String var2, Properties var3, boolean var4, boolean var5);

    @Lock
    public MoveMultiStatusHolder move(Set<RepoPath> var1, RepoPath var2, Properties var3, boolean var4, boolean var5);

    public MoveMultiStatusHolder move(RepoPath var1, String var2, String var3, Properties var4, List<String> var5, boolean var6, boolean var7, int var8);

    public MoveMultiStatusHolder copy(RepoPath var1, String var2, String var3, Properties var4, List<String> var5, boolean var6, boolean var7, int var8);

    public MoveMultiStatusHolder copy(RepoPath var1, RepoPath var2, boolean var3, boolean var4, boolean var5, boolean var6, Properties var7, boolean var8);

    public MoveMultiStatusHolder copyToCache(RepoPath var1, RepoPath var2, boolean var3, boolean var4, boolean var5, boolean var6, Properties var7, boolean var8);

    public MoveMultiStatusHolder copyMultiTx(RepoPath var1, RepoPath var2, boolean var3, boolean var4, boolean var5);

    public MoveMultiStatusHolder copy(RepoPath var1, RepoPath var2);

    public MoveMultiStatusHolder moveMultiTx(RepoPath var1, RepoPath var2, boolean var3, boolean var4, boolean var5);

    public MoveMultiStatusHolder move(RepoPath var1, RepoPath var2, boolean var3, boolean var4, boolean var5, boolean var6, Properties var7, boolean var8);

    @Lock
    public MoveMultiStatusHolder copy(RepoPath var1, RepoPath var2, boolean var3, boolean var4, boolean var5);

    @Lock
    public MoveMultiStatusHolder copy(Set<RepoPath> var1, String var2, Properties var3, boolean var4, boolean var5);

    @Lock
    public MoveMultiStatusHolder delete(Set<RepoPath> var1);

    @Lock
    public int zap(RepoPath var1);

    public Set<String> getAllRepoKeys();

    public Map<Character, List<String>> getAllRepoKeysByFirstCharMap();

    public boolean exists(RepoPath var1);

    public boolean existsBySha1(String var1);

    @Nonnull
    public List<ItemInfo> getChildren(RepoPath var1);

    public List<String> getChildrenNames(RepoPath var1);

    @Lock
    public List<ItemInfo> getChildrenDeeply(RepoPath var1);

    public boolean hasChildren(RepoPath var1);

    public void exportRepo(String var1, ExportSettings var2);

    public ArchiveFileContent getGenericArchiveFileContent(RepoPath var1, String var2) throws IOException;

    public MutableStatusHolder exportSearchResults(SavedSearchResults var1, ExportSettingsImpl var2);

    public VersionSearchResults getVersionUnitsUnder(RepoPath var1);

    public long getArtifactCount();

    public List<LocalRepoDescriptor> getDeployableRepoDescriptors();

    public boolean isRepoPathHandled(RepoPath var1);

    public boolean isLocalOrCachedRepoPathAccepted(RepoPath var1);

    public boolean isLocalOrCachedRepoPathAcceptedOrCanAnotate(RepoPath var1);

    public boolean isRepoPathAccepted(RepoPath var1);

    public boolean isRepoPathVisible(RepoPath var1);

    public List<VirtualRepoDescriptor> getVirtualReposContainingRepo(RepoDescriptor var1);

    public List<VirtualRepoDescriptor> getVirtualReposContainingRepo(RepoDescriptor var1, int var2);

    public boolean virtualItemExists(RepoPath var1);

    public List<RemoteRepoDescriptor> getSharedRemoteRepoConfigs(String var1, Map<String, String> var2);

    public Tree<ZipEntryInfo> zipEntriesToTree(RepoPath var1) throws IOException;

    public ArchiveInputStream archiveInputStream(RepoPath var1) throws IOException;

    public ItemInfo getLastModified(RepoPath var1);

    @Lock
    public void touch(RepoPath var1);

    @Lock
    public void fixChecksums(RepoPath var1);

    public ModuleInfo getItemModuleInfo(RepoPath var1);

    @Lock
    public boolean mkdirs(RepoPath var1);

    public StatusHolder deploy(RepoPath var1, InputStream var2);

    public FileInfo getVirtualFileInfo(RepoPath var1);

    public ItemInfo getVirtualItemInfo(RepoPath var1);

    public FolderInfo getVirtualFolderInfo(RepoPath var1);

    public List<RepoDescriptor> getVirtualResolvedLocalAndCacheDescriptors(String var1);

    public long getArtifactCount(RepoPath var1);

    public FolderSummeryInfo getArtifactCountAndSize(@Nonnull RepoPath var1);

    public long getNodesCount(RepoPath var1);

    public List<FileInfo> searchFilesWithBadChecksum(ChecksumType var1);

    @Nullable
    public StatsInfo getStatsInfo(RepoPath var1);

    public boolean isWriteLocked(RepoPath var1);

    public List<ItemInfo> getOrphanItems(RepoPath var1);

    public void reloadConfigurationLazy();

    public BasicStatusHolder removeRepository(String var1);

    public List<RepoDescriptor> getRepoDescriptorByPackageType(RepoType var1);

    public Map<RepoType, Integer> getRepoDescriptorByPackageTypeCount();
}

